/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.util.HashMap;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoiler;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.tanks.BoilerFuelTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.steam.FluidFuelProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileBoilerFireboxLiquid
extends TileBoilerFirebox {
    private static final int TANK_FUEL = 2;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    protected final BoilerFuelTank tankFuel = new BoilerFuelTank(16000, this);

    public static void placeFluidBoiler(World world, int x, int y, int z, int width, int height, boolean highPressure, int water, FluidStack fuel) {
        for (MultiBlockPattern pattern : TileBoiler.patterns) {
            if (pattern.getPatternHeight() - 3 != height || pattern.getPatternWidthX() - 2 != width) continue;
            HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
            blockMapping.put(Character.valueOf('F'), EnumMachineBeta.BOILER_FIREBOX_LIQUID.ordinal());
            blockMapping.put(Character.valueOf('H'), highPressure ? EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal() : EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal());
            TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineBeta(), blockMapping);
            if (tile instanceof TileBoilerFireboxLiquid) {
                TileBoilerFireboxLiquid master = (TileBoilerFireboxLiquid)tile;
                master.tankWater.setFluid(Fluids.WATER.get(water));
                master.tankFuel.setFluid(fuel);
            }
            return;
        }
    }

    public TileBoilerFireboxLiquid() {
        super(2);
        this.tankManager.add(this.tankFuel);
        this.boiler.setFuelProvider(new FluidFuelProvider(this.tankFuel));
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.BOILER_FIREBOX_LIQUID;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.BOILER_LIQUID, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleClick(EntityPlayer player, int side) {
        if (FluidHelper.handleRightClick(this, ForgeDirection.getOrientation((int)side), player, true, false)) {
            return true;
        }
        return super.handleClick(player, side);
    }

    @Override
    protected void process() {
    }

    @Override
    protected void processBuckets() {
        super.processBuckets();
        FluidHelper.drainContainers(this, this.inventory, 0, 1);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (Fluids.WATER.is(resource)) {
            return this.fill(0, resource, doFill);
        }
        return this.fill(2, resource, doFill);
    }

    public boolean func_94042_c() {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                Fluid fluid = FluidHelper.getFluidInContianer(stack);
                if (fluid == null) {
                    return false;
                }
                if (!Fluids.WATER.is(fluid) && FuelManager.getBoilerFuelValue(fluid) <= 0) break;
                return true;
            }
        }
        return false;
    }
}

