/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackLockdown;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import net.minecraft.entity.item.EntityMinecart;

public class TrackLockdownTrain
extends TrackLockdown {
    private Train currentTrain;
    private boolean justLoaded = true;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LOCKDOWN_TRAIN;
    }

    @Override
    protected byte getDelayTime() {
        return 100;
    }

    @Override
    protected void setCurrentCart(EntityMinecart cart) {
        super.setCurrentCart(cart);
        this.currentTrain = cart == null ? null : LinkageManager.instance().getTrain(cart);
    }

    @Override
    protected void checkCart(EntityMinecart cart) {
        if (this.delay > 0) {
            Train train = LinkageManager.instance().getTrain(cart);
            if (this.justLoaded) {
                this.setCurrentCart(cart);
                this.delay = this.getDelayTime();
            } else if (this.currentTrain != train) {
                this.delay = 0;
                this.setCurrentCart(cart);
            } else {
                this.delay = this.getDelayTime();
            }
        } else {
            this.justLoaded = false;
        }
    }
}

