/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.ILiquidTransfer;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EntityCartTank
extends CartContainerBase
implements IFluidHandler,
ILiquidTransfer,
IEntityAdditionalSpawnData,
ISidedInventory,
IMinecart {
    private static final byte FLUID_ID_DATA_ID = 25;
    private static final byte FLUID_QTY_DATA_ID = 26;
    private static final byte FILLING_DATA_ID = 27;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    private int update = MiscTools.getRand().nextInt();
    private final TankManager tankManager = new TankManager();
    private StandardTank tank = new StandardTank(RailcraftConfig.getTankCartCapacity());
    private final PhantomInventory invFilter = new PhantomInventory(1, (IInventory)this);
    private final IInventory invLiquids = new InventoryMapper((IInventory)this, false);
    private final IInventory invInput = new InventoryMapper((IInventory)this, 0, 1, false);
    private final IInventory invOutput = new InventoryMapper((IInventory)this, 1, 1, false);

    public static ItemStack getFilterFromCartItem(ItemStack cart) {
        int filterId;
        ItemStack filter = null;
        NBTTagCompound nbt = cart.func_77978_p();
        if (nbt != null && (filterId = nbt.func_74762_e("filterId")) > 0 && Item.field_77698_e[filterId] != null) {
            int filterMeta = nbt.func_74762_e("filterMeta");
            filter = new ItemStack(filterId, 1, filterMeta);
        }
        return filter;
    }

    public static ItemStack getCartItemForFilter(ItemStack filter) {
        ItemStack stack = EnumCart.TANK.getCartItem();
        if (filter != null) {
            NBTTagCompound nbt = new NBTTagCompound("tag");
            nbt.func_74768_a("filterId", filter.field_77993_c);
            nbt.func_74768_a("filterMeta", filter.func_77960_j());
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    public EntityCartTank(World world) {
        super(world);
        this.tankManager.add(this.tank);
    }

    public EntityCartTank(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(26, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(27, (Object)0);
    }

    private void setFluidQty(int qty) {
        this.field_70180_af.func_75692_b(26, (Object)qty);
    }

    private int getFluidQty() {
        return this.field_70180_af.func_75679_c(26);
    }

    private void setFluidId(int fluidId) {
        this.field_70180_af.func_75692_b(25, (Object)fluidId);
    }

    private int getFluidId() {
        return this.field_70180_af.func_75679_c(25);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        InvTools.dropInventory(this.invLiquids, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public void func_70071_h_() {
        ItemStack bottomSlot;
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            if (this.getFluidId() != 0) {
                FluidStack fluidStack = new FluidStack(this.getFluidId(), this.getFluidQty());
                this.tank.setFluid(fluidStack);
            } else {
                this.tank.setFluid(null);
            }
            return;
        }
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack != null) {
            if (fluidStack.fluidID != this.getFluidId()) {
                this.setFluidId(fluidStack.fluidID);
            }
            if (fluidStack.amount != this.getFluidQty()) {
                this.setFluidQty(fluidStack.amount);
            }
        } else if (this.getFluidId() != 0) {
            this.setFluidId(0);
            this.setFluidQty(0);
        }
        ++this.update;
        ItemStack topSlot = this.invLiquids.func_70301_a(0);
        if (topSlot != null && !FluidHelper.isContainer(topSlot)) {
            this.invLiquids.func_70299_a(0, null);
            this.func_70099_a(topSlot, 1.0f);
        }
        if ((bottomSlot = this.invLiquids.func_70301_a(1)) != null && !FluidHelper.isContainer(bottomSlot)) {
            this.invLiquids.func_70299_a(1, null);
            this.func_70099_a(bottomSlot, 1.0f);
        }
        if (this.update % 8 == 0) {
            FluidHelper.processContainers(this.tank, this.invLiquids, 0, 1);
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            if (FluidHelper.handleRightClick(this, ForgeDirection.UNKNOWN, player, true, true)) {
                return true;
            }
            GuiHandler.openGui(EnumGui.CART_TANK, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack drop = EnumCart.TANK.getCartItem();
        if (this.hasFilter()) {
            NBTTagCompound nbt = new NBTTagCompound("tag");
            nbt.func_74768_a("filterId", this.getFilterItem().field_77993_c);
            nbt.func_74768_a("filterMeta", this.getFilterItem().func_77960_j());
            drop.func_77982_d(nbt);
        }
        return drop;
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    public String func_70303_b() {
        return RailcraftLanguage.translate(EnumCart.TANK.getTag());
    }

    protected void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.invFilter.readFromNBT("invFilter", data);
        this.tankManager.readTanksFromNBT(data);
    }

    protected void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        this.invFilter.writeToNBT("invFilter", data);
        this.tankManager.writeTanksToNBT(data);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        Fluid filterFluid = this.getFilterFluid();
        if (filterFluid == null || resource.getFluid() == filterFluid) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (this.tank.getFluidType() == resource.getFluid()) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        Fluid filterFluid = this.getFilterFluid();
        return filterFluid == null || fluid == filterFluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        return this.tankManager.getTankInfo();
    }

    @Override
    public void setFilling(boolean fill) {
        this.field_70180_af.func_75692_b(27, (Object)(fill ? (byte)1 : 0));
    }

    @Override
    public boolean isFilling() {
        return this.field_70180_af.func_75683_a(27) != 0;
    }

    public boolean hasFilter() {
        return this.getFilterItem() != null;
    }

    public Fluid getFilterFluid() {
        ItemStack filter = this.getFilterItem();
        if (filter == null) {
            return null;
        }
        return FluidHelper.getFluidInContianer(filter);
    }

    public ItemStack getFilterItem() {
        return this.getFilter().func_70301_a(0);
    }

    public void setFilter(ItemStack filter) {
        this.getFilter().func_70299_a(0, filter);
    }

    public PhantomInventory getFilter() {
        return this.invFilter;
    }

    public IInventory getInvLiquids() {
        return this.invLiquids;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.getFilterItem() != null ? this.getFilterItem().field_77993_c : 0);
        data.writeInt(this.getFilterItem() != null ? this.getFilterItem().func_77960_j() : 0);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        int filterId = data.readInt();
        int filterMeta = data.readInt();
        if (filterId > 0) {
            ItemStack filter = new ItemStack(filterId, 1, filterMeta);
            this.setFilter(filter);
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && FluidHelper.isContainer(stack);
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return ItemCart.getCartType(stack) == EnumCart.TANK;
    }

    @Override
    public int offerLiquid(Object source, FluidStack offer) {
        int qty = offer.amount;
        int used = this.fill(ForgeDirection.UNKNOWN, offer, true);
        offer.amount = qty - used;
        if (offer.amount <= 0) {
            return used;
        }
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            used += ((ILiquidTransfer)linkedCart).offerLiquid(this, offer);
        }
        offer.amount = qty - used;
        if (offer.amount <= 0) {
            return used;
        }
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            used += ((ILiquidTransfer)linkedCart).offerLiquid(this, offer);
        }
        return used;
    }

    @Override
    public int requestLiquid(Object source, FluidStack request) {
        FluidStack acquired = this.drain(ForgeDirection.UNKNOWN, request.amount, false);
        if (acquired == null || !request.isFluidEqual(acquired)) {
            return 0;
        }
        this.drain(ForgeDirection.UNKNOWN, request.amount, true);
        if (acquired.amount >= request.amount) {
            return acquired.amount;
        }
        FluidStack newRequest = request.copy();
        newRequest.amount = request.amount - acquired.amount;
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            acquired.amount += ((ILiquidTransfer)linkedCart).requestLiquid(this, newRequest);
        }
        if (acquired.amount >= request.amount) {
            return acquired.amount;
        }
        newRequest.amount = request.amount - acquired.amount;
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            acquired.amount += ((ILiquidTransfer)linkedCart).requestLiquid(this, newRequest);
        }
        return acquired.amount;
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }
}

