/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import buildcraft.api.power.PowerHandler;
import mods.railcraft.common.blocks.machine.alpha.TileEngravingBench;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotPassThrough;
import mods.railcraft.common.gui.widgets.EmblemBankWidget;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEngravingBench
extends RailcraftContainer {
    private final TileEngravingBench tile;
    private int lastEnergy;
    private int lastProgress;
    public EmblemBankWidget emblemBank;

    public ContainerEngravingBench(InventoryPlayer inventoryplayer, TileEngravingBench tile) {
        super(tile);
        this.tile = tile;
        this.addWidget(new IndicatorWidget(tile.getEnergyIndicator(), 157, 50, 176, 12, 6, 48));
        this.emblemBank = new EmblemBankWidget(25, 25, tile.currentEmblem);
        this.addWidget(this.emblemBank);
        this.addSlot(new SlotPassThrough(tile, 0, 35, 66));
        this.addSlot(new SlotOutput(tile, 1, 125, 66));
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int l1 = 0; l1 < 9; ++l1) {
                this.addSlot(new Slot((IInventory)inventoryplayer, l1 + i1 * 9 + 9, 8 + l1 * 18, 133 + i1 * 18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j1, 8 + j1 * 18, 191));
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        PowerHandler.PowerReceiver provider = this.tile.getPowerReceiver(null);
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            if (this.lastProgress != this.tile.getProgress()) {
                icrafting.func_71112_a((Container)this, 0, this.tile.getProgress());
            }
            if (provider == null || (float)this.lastEnergy == provider.getEnergyStored()) continue;
            icrafting.func_71112_a((Container)this, 1, (int)provider.getEnergyStored());
        }
        this.lastProgress = this.tile.getProgress();
        if (provider != null) {
            this.lastEnergy = (int)provider.getEnergyStored();
        }
    }

    @Override
    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        icrafting.func_71112_a((Container)this, 0, this.tile.getProgress());
        PowerHandler.PowerReceiver provider = this.tile.getPowerReceiver(null);
        if (provider != null) {
            icrafting.func_71112_a((Container)this, 1, (int)provider.getEnergyStored());
        }
    }

    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0: {
                this.tile.setProgress(data);
                break;
            }
            case 1: {
                this.tile.guiEnergy = data;
            }
        }
    }
}

