/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mods.railcraft.client.gui.GuiContainerRailcraft;
import mods.railcraft.common.emblems.EmblemManager;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.widgets.EmblemBankSlotWidget;
import mods.railcraft.common.gui.widgets.EmblemSlotWidget;
import mods.railcraft.common.gui.widgets.Widget;
import mods.railcraft.common.util.misc.RevolvingList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ICrafting;

public class EmblemBankWidget
extends Widget {
    private static final int NUM_SLOTS = 7;
    private List slots = new ArrayList(7);
    private RevolvingList emblems = new RevolvingList();
    String currentSelection = "";

    public EmblemBankWidget(int x, int y, String currentEmblem) {
        super(x, y, 182, 12, 126, 18);
        for (int i = 0; i < 7; ++i) {
            this.slots.add(new EmblemBankSlotWidget(this, i, x + 1 + i * 18, y + 1, this.u, this.v));
        }
        this.currentSelection = currentEmblem;
    }

    @Override
    public void addToContainer(RailcraftContainer container) {
        super.addToContainer(container);
        for (EmblemSlotWidget slot : this.slots) {
            container.addWidget(slot);
        }
    }

    public List getSlots() {
        return this.slots;
    }

    public String getEmblem(int index) {
        List view = (List)this.emblems.getCurrent();
        if (view == null || index >= view.size()) {
            return "";
        }
        return (String)view.get(index);
    }

    public String getSelectedEmblem() {
        return this.currentSelection;
    }

    public void shiftLeft() {
        this.emblems.rotateLeft();
    }

    public void shiftRight() {
        this.emblems.rotateRight();
    }

    @Override
    public void draw(GuiContainerRailcraft gui, int guiX, int guiY, int mouseX, int mouseY) {
    }

    @Override
    public void initWidget(ICrafting player) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeUTF(this.currentSelection);
            Set unlockedEmblems = EmblemManager.getUnlockedEmblems((EntityPlayer)player);
            data.writeShort(unlockedEmblems.size());
            for (String s : unlockedEmblems) {
                data.writeUTF(s);
            }
            this.container.sendWidgetDataToClient(this, player, bytes.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientPacketData(DataInputStream data) throws IOException {
        ArrayList<String> emblemView;
        this.currentSelection = data.readUTF();
        int count = data.readShort();
        int subIndex = 0;
        ArrayList<String> currentView = emblemView = new ArrayList<String>(7);
        for (int i = 0; i < count; ++i) {
            if (subIndex >= 7) {
                subIndex = 0;
                this.emblems.add(emblemView);
                emblemView = new ArrayList(7);
            }
            String identifier = data.readUTF();
            emblemView.add(identifier);
            if (this.currentSelection.equals(identifier)) {
                currentView = emblemView;
            }
            ++subIndex;
        }
        this.emblems.add(emblemView);
        this.emblems.setCurrent(currentView);
    }
}

