/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import java.util.ArrayList;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.anvil.BlockRCAnvil;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemDust;
import mods.railcraft.common.items.ItemIngot;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.modules.AbstractModule;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.misc.BallastRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleFactory
extends AbstractModule {
    private static final int COKE_COOK_TIME = 1800;
    private static final int COKE_COOK_CREOSOTE = 500;

    @Override
    public void initFirst() {
        ItemStack stack;
        EnumMachineAlpha alpha;
        BlockCube.registerBlock();
        RailcraftToolItems.registerCoalCoke();
        BlockRCAnvil.registerBlock();
        if (BlockRCAnvil.getBlock() != null) {
            CraftingPlugin.addShapedOreRecipe(new ItemStack(BlockRCAnvil.getBlock(), 1, 0), "BBB", " I ", "III", Character.valueOf('B'), "blockSteel", Character.valueOf('I'), "ingotSteel");
        }
        if ((alpha = EnumMachineAlpha.COKE_OVEN).register()) {
            stack = alpha.getItem();
            CraftingPlugin.addShapedRecipe(stack, "MBM", "BMB", "MBM", Character.valueOf('B'), new ItemStack(Item.field_77772_aH), Character.valueOf('M'), new ItemStack(Block.field_71939_E));
            if (RailcraftToolItems.getCoalCoke() != null) {
                RailcraftCraftingManager.cokeOven.addRecipe(new ItemStack(Item.field_77705_m, 1, 0), true, false, RailcraftToolItems.getCoalCoke(), Fluids.CREOSOTE.get(500), 1800);
            }
        }
        if ((alpha = EnumMachineAlpha.STEAM_OVEN).register()) {
            CraftingPlugin.addShapedRecipe(alpha.getItem(4), "SSS", "SFS", "SSS", Character.valueOf('F'), new ItemStack(Block.field_72051_aB), Character.valueOf('S'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL));
        }
        if ((alpha = EnumMachineAlpha.BLAST_FURNACE).register()) {
            stack = alpha.getItem(4);
            CraftingPlugin.addShapedRecipe(stack, "MBM", "BPB", "MBM", Character.valueOf('B'), new ItemStack(Block.field_72033_bA), Character.valueOf('M'), new ItemStack(Block.field_72013_bc), Character.valueOf('P'), Item.field_77725_bx);
            int burnTime = 1280;
            if (IC2Plugin.isModInstalled() && RailcraftConfig.getRecipeConfig("ic2.refinedIron.disable") && RailcraftConfig.getRecipeConfig("ic2.refinedIron.useSteel")) {
                burnTime = RailcraftConfig.getSteelCookTime();
            }
            ItemIngot.EnumIngot steel = ItemIngot.EnumIngot.STEEL;
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Item.field_77703_o), false, false, burnTime, ItemIngot.getIngot(steel, 1));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack((Item)Item.field_77812_ad), true, false, burnTime * 5, ItemIngot.getIngot(steel, 5));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack((Item)Item.field_77822_ae), true, false, burnTime * 8, ItemIngot.getIngot(steel, 8));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack((Item)Item.field_77824_af), true, false, burnTime * 7, ItemIngot.getIngot(steel, 7));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack((Item)Item.field_77818_ag), true, false, burnTime * 4, ItemIngot.getIngot(steel, 4));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Item.field_77716_q), true, false, burnTime * 2, ItemIngot.getIngot(steel, 2));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Item.field_77695_f), true, false, burnTime, ItemIngot.getIngot(steel, 1));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Item.field_77696_g), true, false, burnTime * 3, ItemIngot.getIngot(steel, 3));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Item.field_77708_h), true, false, burnTime * 3, ItemIngot.getIngot(steel, 3));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Item.field_77689_P), true, false, burnTime * 2, ItemIngot.getIngot(steel, 2));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack((Item)Item.field_77745_be), true, false, burnTime * 2, ItemIngot.getIngot(steel, 2));
            RailcraftCraftingManager.blastFurnace.addRecipe(ItemCrowbar.getItem(), true, false, burnTime * 3, ItemIngot.getIngot(steel, 3));
            RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Item.field_77766_aB), false, false, burnTime * 6, ItemIngot.getIngot(steel, 6));
            int recycleTime = burnTime / 2;
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelHelm(), false, false, recycleTime * 4, ItemIngot.getIngot(steel, 4));
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelArmor(), false, false, recycleTime * 6, ItemIngot.getIngot(steel, 6));
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelLegs(), false, false, recycleTime * 5, ItemIngot.getIngot(steel, 5));
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelBoots(), false, false, recycleTime * 3, ItemIngot.getIngot(steel, 3));
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelSword(), false, false, recycleTime * 1, ItemIngot.getIngot(steel, 1));
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelPickaxe(), false, false, recycleTime * 2, ItemIngot.getIngot(steel, 2));
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelHoe(), false, false, recycleTime * 1, ItemIngot.getIngot(steel, 1));
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelAxe(), false, false, recycleTime * 2, ItemIngot.getIngot(steel, 2));
            RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelShears(), false, false, recycleTime * 1, ItemIngot.getIngot(steel, 1));
        }
        if ((alpha = EnumMachineAlpha.ROCK_CRUSHER).register()) {
            stack = alpha.getItem(4);
            CraftingPlugin.addShapedOreRecipe(stack, "PDP", "DSD", "PDP", Character.valueOf('D'), new ItemStack(Item.field_77702_n), Character.valueOf('P'), new ItemStack((Block)Block.field_71963_Z), Character.valueOf('S'), "blockSteel");
            IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72089_ap), false, false);
            recipe.addOutput(EnumCube.CRUSHED_OBSIDIAN.getItem(), 1.0f);
            recipe.addOutput(ItemDust.getDust(ItemDust.EnumDust.OBSIDIAN), 0.25f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumCube.CRUSHED_OBSIDIAN.getItem(), true, false);
            recipe.addOutput(ItemDust.getDust(ItemDust.EnumDust.OBSIDIAN), 1.0f);
            recipe.addOutput(ItemDust.getDust(ItemDust.EnumDust.OBSIDIAN), 0.25f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumMachineAlpha.COKE_OVEN.getItem(), true, false);
            recipe.addOutput(new ItemStack(Item.field_77772_aH, 3), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77772_aH), 0.5f);
            recipe.addOutput(new ItemStack(Block.field_71939_E), 0.25f);
            recipe.addOutput(new ItemStack(Block.field_71939_E), 0.25f);
            recipe.addOutput(new ItemStack(Block.field_71939_E), 0.25f);
            recipe.addOutput(new ItemStack(Block.field_71939_E), 0.25f);
            recipe.addOutput(new ItemStack(Block.field_71939_E), 0.25f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumMachineAlpha.BLAST_FURNACE.getItem(), true, false);
            recipe.addOutput(new ItemStack(Block.field_72033_bA), 0.75f);
            recipe.addOutput(new ItemStack(Block.field_72013_bc), 0.75f);
            recipe.addOutput(new ItemStack(Item.field_77722_bw), 0.05f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumMachineAlpha.WORLD_ANCHOR.getItem(), true, false);
            recipe.addOutput(EnumCube.CRUSHED_OBSIDIAN.getItem(), 1.0f);
            recipe.addOutput(EnumCube.CRUSHED_OBSIDIAN.getItem(), 0.5f);
            recipe.addOutput(new ItemStack(Item.field_77702_n), 0.5f);
            recipe.addOutput(new ItemStack(Block.field_72089_ap), 0.25f);
            recipe.addOutput(ItemDust.getDust(ItemDust.EnumDust.OBSIDIAN), 0.25f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq, 16), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq, 8), 0.5f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq, 8), 0.5f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq, 4), 0.5f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumMachineAlpha.PERSONAL_ANCHOR.getItem(), true, false);
            recipe.addOutput(EnumCube.CRUSHED_OBSIDIAN.getItem(), 1.0f);
            recipe.addOutput(EnumCube.CRUSHED_OBSIDIAN.getItem(), 0.5f);
            recipe.addOutput(new ItemStack(Item.field_77817_bH), 0.5f);
            recipe.addOutput(new ItemStack(Block.field_72089_ap), 0.25f);
            recipe.addOutput(ItemDust.getDust(ItemDust.EnumDust.OBSIDIAN), 0.25f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq, 16), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq, 8), 0.5f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq, 8), 0.5f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq, 4), 0.5f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_71978_w), false, false);
            recipe.addOutput(new ItemStack(Block.field_71940_F), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77804_ap), 0.1f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72087_ao), false, false);
            recipe.addOutput(new ItemStack(Block.field_71940_F), 1.0f);
            recipe.addOutput(new ItemStack(Block.field_71998_bu), 0.1f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_71940_F), false, false);
            recipe.addOutput(new ItemStack(Block.field_71939_E), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77733_bq), 0.001f);
            recipe.addOutput(new ItemStack(Item.field_77702_n), 5.0E-5f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_71981_t), false, false);
            recipe.addOutput(new ItemStack(Block.field_71978_w), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_71957_Q), false, false);
            recipe.addOutput(new ItemStack(Block.field_71939_E, 4), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72081_al), false, false);
            recipe.addOutput(new ItemStack(Item.field_77772_aH, 3), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77772_aH), 0.5f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72041_aW), false, false);
            recipe.addOutput(new ItemStack(Item.field_77757_aI, 4), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72007_bm), false, false);
            recipe.addOutput(new ItemStack(Block.field_71978_w), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72057_aH), false, false);
            recipe.addOutput(new ItemStack(Block.field_71940_F), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_71995_bx), false, false);
            recipe.addOutput(new ItemStack(Block.field_71978_w), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72100_bC), false, false);
            recipe.addOutput(new ItemStack(Block.field_72033_bA), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_71992_bw), false, false);
            recipe.addOutput(new ItemStack(Item.field_77772_aH, 4), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77772_aH), 0.5f);
            recipe.addOutput(new ItemStack(Item.field_77772_aH), 0.5f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack((Block)Block.field_72079_ak, 1, 0), true, false);
            recipe.addOutput(new ItemStack(Block.field_71978_w), 0.45f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack((Block)Block.field_72079_ak, 1, 1), true, false);
            recipe.addOutput(new ItemStack(Block.field_71939_E), 0.45f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack((Block)Block.field_72079_ak, 1, 3), true, false);
            recipe.addOutput(new ItemStack(Block.field_71940_F), 0.45f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack((Block)Block.field_72079_ak, 1, 4), true, false);
            recipe.addOutput(new ItemStack(Item.field_77772_aH), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77772_aH), 0.75f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack((Block)Block.field_72079_ak, 1, 5), true, false);
            recipe.addOutput(new ItemStack(Block.field_71978_w), 0.45f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72036_aT), false, false);
            recipe.addOutput(new ItemStack(Block.field_72039_aU), 0.85f);
            recipe.addOutput(new ItemStack(Item.field_77768_aD), 0.25f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72098_bB), false, false);
            recipe.addOutput(new ItemStack(Block.field_72033_bA), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72014_bd), false, false);
            recipe.addOutput(new ItemStack(Item.field_77751_aT, 3), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77751_aT), 0.75f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Block.field_72078_bL), false, false);
            recipe.addOutput(new ItemStack(Item.field_77751_aT, 3), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77751_aT), 0.75f);
            recipe.addOutput(new ItemStack(Item.field_77767_aC, 3), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77767_aC), 0.75f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Item.field_77755_aX), false, false);
            recipe.addOutput(new ItemStack(Item.field_77756_aW, 4, 15), 1.0f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Item.field_77731_bo), false, false);
            recipe.addOutput(new ItemStack(Item.field_77722_bw, 2), 1.0f);
            recipe.addOutput(new ItemStack(Item.field_77722_bw), 0.25f);
            recipe.addOutput(new ItemStack(Item.field_77722_bw), 0.25f);
            recipe.addOutput(new ItemStack(Item.field_77722_bw), 0.25f);
            recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(Item.field_77705_m, 1, 1), true, false);
            recipe.addOutput(ItemDust.getDust(ItemDust.EnumDust.CHARCOAL), 1.0f);
        }
        if ((alpha = EnumMachineAlpha.ROLLING_MACHINE).register()) {
            stack = alpha.getItem();
            CraftingPlugin.addShapedRecipe(stack, "IPI", "PCP", "IPI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('C'), Block.field_72060_ay);
        } else {
            RollingMachineCraftingManager.copyRecipesToWorkbench();
        }
        if (BlockCube.getBlock() != null) {
            EnumCube type = EnumCube.STEEL_BLOCK;
            if (RailcraftConfig.isSubBlockEnabled(type.getTag())) {
                ItemStack stack2 = type.getItem();
                RailcraftLanguage.instance().registerItemName(stack2, type.getTag());
                CraftingPlugin.addShapedOreRecipe(stack2, "III", "III", "III", Character.valueOf('I'), "ingotSteel");
                CraftingPlugin.addShapelessRecipe(ItemIngot.getIngot(ItemIngot.EnumIngot.STEEL, 9), stack2);
                LootPlugin.addLootTool(stack2.func_77946_l(), 1, 1, "steel.block");
                OreDictionary.registerOre((String)"blockSteel", (ItemStack)stack2);
                if (EnumMachineAlpha.BLAST_FURNACE.isAvaliable()) {
                    RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack(Block.field_72083_ai), false, false, 11520, EnumCube.STEEL_BLOCK.getItem());
                }
            }
            if (RailcraftConfig.isSubBlockEnabled((type = EnumCube.CRUSHED_OBSIDIAN).getTag())) {
                ItemStack stack3 = type.getItem();
                RailcraftLanguage.instance().registerItemName(stack3, type.getTag());
                BallastRegistry.registerBallast(BlockCube.getBlock().field_71990_ca, type.ordinal());
                if (IC2Plugin.isModInstalled() && RailcraftConfig.addObsidianRecipesToMacerator()) {
                    IC2Plugin.addMaceratorRecipe(new ItemStack(Block.field_72089_ap), stack3);
                    IC2Plugin.addMaceratorRecipe(stack3, ItemDust.getDust(ItemDust.EnumDust.OBSIDIAN));
                }
            }
            if (RailcraftConfig.isSubBlockEnabled((type = EnumCube.COKE_BLOCK).getTag())) {
                BlockCube.registerBlock();
                BlockCube cube = BlockCube.getBlock();
                if (cube != null) {
                    ItemStack stack4 = type.getItem();
                    RailcraftLanguage.instance().registerItemName(stack4, type.getTag());
                    CraftingPlugin.addShapedRecipe(stack4, "CCC", "CCC", "CCC", Character.valueOf('C'), RailcraftToolItems.getCoalCoke());
                    CraftingPlugin.addShapelessRecipe(RailcraftToolItems.getCoalCoke(9), stack4);
                }
            }
        }
    }

    @Override
    public void initSecond() {
        if (ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES)) {
            ItemStack stack;
            if (EnumMachineAlpha.BLAST_FURNACE.isAvaliable() && BlockBrick.infernal != null) {
                stack = EnumMachineAlpha.BLAST_FURNACE.getItem(4);
                CraftingPlugin.addShapedRecipe(stack, " B ", "BPB", " B ", Character.valueOf('B'), BlockBrick.infernal.getItemStack(BlockBrick.BrickVariant.BRICK, 1), Character.valueOf('P'), Item.field_77725_bx);
            }
            if (EnumMachineAlpha.COKE_OVEN.isAvaliable() && BlockBrick.sandy != null) {
                stack = EnumMachineAlpha.COKE_OVEN.getItem();
                CraftingPlugin.addShapedRecipe(stack, " B ", " S ", " B ", Character.valueOf('B'), BlockBrick.sandy.getItemStack(BlockBrick.BrickVariant.BRICK, 1), Character.valueOf('S'), new ItemStack(Block.field_71939_E));
            }
        }
        if (EnumCube.COKE_BLOCK.isEnabled()) {
            RailcraftCraftingManager.cokeOven.addRecipe(new ItemStack(Block.field_111034_cE), false, false, EnumCube.COKE_BLOCK.getItem(), Fluids.CREOSOTE.get(4500), 16200);
        }
        if (Fluids.CREOSOTE.get() != null && RailcraftConfig.creosoteTorchOutput() > 0) {
            FluidStack creosote = Fluids.CREOSOTE.get(1000);
            for (ItemStack container : FluidHelper.getContainersFilledWith(creosote)) {
                CraftingPlugin.addShapedOreRecipe(new ItemStack(Block.field_72069_aq, RailcraftConfig.creosoteTorchOutput()), "C", "W", "S", Character.valueOf('C'), container, Character.valueOf('W'), Block.field_72101_ab, Character.valueOf('S'), Item.field_77669_D);
            }
            ForestryPlugin.addCarpenterRecipe("torches", 10, Fluids.CREOSOTE.get(1000), null, new ItemStack(Block.field_72069_aq, RailcraftConfig.creosoteTorchOutput()), "#", "|", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('|'), Item.field_77669_D);
        }
    }

    private void registerCrushedOreRecipe(ItemStack ore, ItemStack dust) {
        if (dust == null) {
            return;
        }
        dust = dust.func_77946_l();
        dust.field_77994_a = 2;
        IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(ore, true, false);
        recipe.addOutput(dust, 1.0f);
    }

    @Override
    public void postInit() {
        if (OreDictionary.getOres((String)"blockSteel").isEmpty()) {
            OreDictionary.registerOre((String)"blockSteel", (Block)Block.field_72083_ai);
        }
        if (!EnumMachineAlpha.BLAST_FURNACE.isAvaliable()) {
            ModuleFactory.registerAltSteelFurnaceRecipe();
        }
        ArrayList logs = new ArrayList(25);
        logs.addAll(OreDictionary.getOres((String)"logWood"));
        logs.addAll(OreDictionary.getOres((String)"woodRubber"));
        for (ItemStack log : logs) {
            RailcraftCraftingManager.cokeOven.addRecipe(log, true, false, new ItemStack(Item.field_77705_m, 1, 1), Fluids.CREOSOTE.get(250), 1800);
        }
        if (IC2Plugin.isModInstalled()) {
            ItemStack crushedIron = IC2Plugin.getItem("crushedIronOre");
            ItemStack crushedGold = IC2Plugin.getItem("crushedGoldOre");
            ItemStack crushedCopper = IC2Plugin.getItem("crushedCopperOre");
            ItemStack crushedTin = IC2Plugin.getItem("crushedTinOre");
            ItemStack crushedSilver = IC2Plugin.getItem("crushedSilverOre");
            ItemStack crushedLead = IC2Plugin.getItem("crushedLeadOre");
            ItemStack crushedUranium = IC2Plugin.getItem("crushedUraniumOre");
            if (RailcraftConfig.canCrushOres()) {
                this.registerCrushedOreRecipe(new ItemStack(Block.field_71949_H), crushedIron);
                this.registerCrushedOreRecipe(new ItemStack(Block.field_71941_G), crushedGold);
                ArrayList ores = OreDictionary.getOres((String)"oreCopper");
                for (ItemStack ore : ores) {
                    this.registerCrushedOreRecipe(ore, crushedCopper);
                }
                ores = OreDictionary.getOres((String)"oreTin");
                for (ItemStack ore : ores) {
                    this.registerCrushedOreRecipe(ore, crushedTin);
                }
                ores = OreDictionary.getOres((String)"oreSilver");
                for (ItemStack ore : ores) {
                    this.registerCrushedOreRecipe(ore, crushedSilver);
                }
                ores = OreDictionary.getOres((String)"oreLead");
                for (ItemStack ore : ores) {
                    this.registerCrushedOreRecipe(ore, crushedLead);
                }
                ores = OreDictionary.getOres((String)"oreUranium");
                for (ItemStack ore : ores) {
                    this.registerCrushedOreRecipe(ore, crushedUranium);
                }
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.ores")) {
                IC2Plugin.removeMaceratorDustRecipes(crushedIron, crushedGold, crushedCopper, crushedTin, crushedSilver, crushedLead, crushedUranium);
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.bones")) {
                IC2Plugin.removeMaceratorRecipes(new ItemStack(Item.field_77756_aW, 1, 15));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.blaze")) {
                IC2Plugin.removeMaceratorRecipes(new ItemStack(Item.field_77722_bw));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.cobble")) {
                IC2Plugin.removeMaceratorRecipes(new ItemStack(Block.field_71978_w));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.dirt")) {
                IC2Plugin.removeMaceratorRecipes(new ItemStack(Block.field_71979_v));
            }
        }
        ForestryPlugin.addCarpenterRecipe("ties", 40, Fluids.CREOSOTE.get(750), null, RailcraftPartItems.getTieWood(), "###", Character.valueOf('#'), "slabWood");
    }

    public static int getFuelValues(int id) {
        if (RailcraftToolItems.getCoalCoke() != null && id == RailcraftToolItems.getCoalCoke().field_77993_c) {
            return 3200;
        }
        return 0;
    }

    private static void registerAltSteelFurnaceRecipe() {
        ArrayList iron = OreDictionary.getOres((String)"nuggetIron");
        for (ItemStack nugget : iron) {
            CraftingPlugin.addFurnaceRecipe(nugget, ItemNugget.getNugget(ItemNugget.EnumNugget.STEEL), 0.0f);
        }
    }

    @Override
    public void postInitNotLoaded() {
        RollingMachineCraftingManager.copyRecipesToWorkbench();
        ModuleFactory.registerAltSteelFurnaceRecipe();
    }
}

