/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class MiscTools {
    public static final Random RANDOM = new Random();

    public static Random getRand() {
        return RANDOM;
    }

    public static boolean isOwnerOrOp(String owner, String accessor) {
        if (owner == null || accessor == null) {
            return false;
        }
        if (owner.equals(accessor)) {
            return true;
        }
        return Game.isPlayerOp(accessor);
    }

    public static boolean isPlayerConnected(String username) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(username) != null;
    }

    public static void registerTrack(EnumTrack rail) {
        RailcraftBlocks.registerBlockTrack();
        if (RailcraftBlocks.getBlockTrack() != null && RailcraftConfig.isSubBlockEnabled(rail.getTag())) {
            rail.initialize();
            ItemStack stack = rail.getTrackSpec().getItem();
            RailcraftLanguage.instance().registerItemName(stack, rail.getTag());
            ItemRegistry.registerItemStack(rail.getTag(), stack);
        }
    }

    public static String cleanTag(String tag) {
        return tag.replace("railcraft.", "").replaceFirst("^tile\\.", "").replaceFirst("^item\\.", "");
    }

    public static void writeUUID(NBTTagCompound data, String tag, UUID uuid) {
        if (uuid == null) {
            return;
        }
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74772_a("most", uuid.getMostSignificantBits());
        nbtTag.func_74772_a("least", uuid.getLeastSignificantBits());
        data.func_74782_a(tag, (NBTBase)nbtTag);
    }

    public static UUID readUUID(NBTTagCompound data, String tag) {
        if (data.func_74764_b(tag)) {
            NBTTagCompound nbtTag = data.func_74775_l(tag);
            return new UUID(nbtTag.func_74763_f("most"), nbtTag.func_74763_f("least"));
        }
        return null;
    }

    public static AxisAlignedBB addCoordToAABB(AxisAlignedBB box, double x, double y, double z) {
        if (x < box.field_72340_a) {
            box.field_72340_a = x;
        } else if (x > box.field_72336_d) {
            box.field_72336_d = x;
        }
        if (y < box.field_72338_b) {
            box.field_72338_b = y;
        } else if (y > box.field_72337_e) {
            box.field_72337_e = y;
        }
        if (z < box.field_72339_c) {
            box.field_72339_c = z;
        } else if (z > box.field_72334_f) {
            box.field_72334_f = z;
        }
        return box;
    }

    public static List getNearbyEntities(World world, Class entityClass, float x, float minY, float maxY, float z, float radius) {
        AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)minY, (double)z, (double)(x + 1.0f), (double)maxY, (double)(z + 1.0f));
        box = box.func_72314_b((double)radius, 0.0, (double)radius);
        return world.func_72872_a(entityClass, box);
    }

    public static List getEntitiesAt(World world, Class entityClass, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        return world.func_82733_a(entityClass, box, IEntitySelector.field_94557_a);
    }

    public static Entity getEntityAt(World world, Class entityClass, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        List entities = world.func_82733_a(entityClass, box, IEntitySelector.field_94557_a);
        if (!entities.isEmpty()) {
            return (Entity)entities.get(0);
        }
        return null;
    }

    public static MovingObjectPosition collisionRayTrace(Vec3 vec3d, Vec3 vec3d1, int i, int j, int k) {
        vec3d = vec3d.func_72441_c((double)(-i), (double)(-j), (double)(-k));
        vec3d1 = vec3d1.func_72441_c((double)(-i), (double)(-j), (double)(-k));
        Vec3 vec3d2 = vec3d.func_72429_b(vec3d1, 0.0);
        Vec3 vec3d3 = vec3d.func_72429_b(vec3d1, 1.0);
        Vec3 vec3d4 = vec3d.func_72435_c(vec3d1, 0.0);
        Vec3 vec3d5 = vec3d.func_72435_c(vec3d1, 1.0);
        Vec3 vec3d6 = vec3d.func_72434_d(vec3d1, 0.0);
        Vec3 vec3d7 = vec3d.func_72434_d(vec3d1, 1.0);
        if (!MiscTools.isVecInsideYZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!MiscTools.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!MiscTools.isVecInsideXZBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!MiscTools.isVecInsideXZBounds(vec3d5)) {
            vec3d5 = null;
        }
        if (!MiscTools.isVecInsideXYBounds(vec3d6)) {
            vec3d6 = null;
        }
        if (!MiscTools.isVecInsideXYBounds(vec3d7)) {
            vec3d7 = null;
        }
        Vec3 vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.func_72438_d(vec3d2) < vec3d.func_72438_d(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.func_72438_d(vec3d3) < vec3d.func_72438_d(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.func_72438_d(vec3d4) < vec3d.func_72438_d(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.func_72438_d(vec3d5) < vec3d.func_72438_d(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.func_72438_d(vec3d6) < vec3d.func_72438_d(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.func_72438_d(vec3d7) < vec3d.func_72438_d(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new MovingObjectPosition(i, j, k, byte0, vec3d8.func_72441_c((double)i, (double)j, (double)k));
    }

    private static boolean isVecInsideYZBounds(Vec3 vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.field_72448_b >= 0.0 && vec3d.field_72448_b <= 1.0 && vec3d.field_72449_c >= 0.0 && vec3d.field_72449_c <= 1.0;
    }

    private static boolean isVecInsideXZBounds(Vec3 vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.field_72450_a >= 0.0 && vec3d.field_72450_a <= 1.0 && vec3d.field_72449_c >= 0.0 && vec3d.field_72449_c <= 1.0;
    }

    private static boolean isVecInsideXYBounds(Vec3 vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.field_72450_a >= 0.0 && vec3d.field_72450_a <= 1.0 && vec3d.field_72448_b >= 0.0 && vec3d.field_72448_b <= 1.0;
    }

    public static ForgeDirection getCurrentMousedOverSide(EntityPlayer player) {
        double distance = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        posVec.field_72448_b += (double)player.func_70047_e();
        lookVec = posVec.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        MovingObjectPosition mouseOver = player.field_70170_p.func_72933_a(posVec, lookVec);
        if (mouseOver != null) {
            return ForgeDirection.getOrientation((int)mouseOver.field_72310_e);
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ForgeDirection getSideClosestToPlayer(World world, int i, int j, int k, EntityLivingBase entityplayer) {
        if (MathHelper.func_76135_e((float)((float)entityplayer.field_70165_t - (float)i)) < 2.0f && MathHelper.func_76135_e((float)((float)entityplayer.field_70161_v - (float)k)) < 2.0f) {
            double d = entityplayer.field_70163_u + 1.82 - (double)entityplayer.field_70129_M;
            if (d - (double)j > 2.0) {
                return ForgeDirection.UP;
            }
            if ((double)j - d > 0.0) {
                return ForgeDirection.DOWN;
            }
        }
        int dir = MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (dir) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
        }
        return dir != 3 ? ForgeDirection.DOWN : ForgeDirection.WEST;
    }

    public static ForgeDirection getHorizontalSideClosestToPlayer(World world, int x, int y, int z, EntityLivingBase player) {
        int dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (dir) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection getOppositeSide(int side) {
        int s = side;
        s = s % 2 == 0 ? s + 1 : s - 1;
        return ForgeDirection.getOrientation((int)s);
    }

    public static int getXOnSide(int x, ForgeDirection side) {
        return x + side.offsetX;
    }

    public static int getYOnSide(int y, ForgeDirection side) {
        return y + side.offsetY;
    }

    public static int getZOnSide(int z, ForgeDirection side) {
        return z + side.offsetZ;
    }

    public static boolean blockExistsOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return world.func_72899_e(MiscTools.getXOnSide(x, side), MiscTools.getYOnSide(y, side), MiscTools.getZOnSide(z, side));
    }

    public static int getBlockMetadataOnSide(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return world.func_72805_g(MiscTools.getXOnSide(i, side), MiscTools.getYOnSide(j, side), MiscTools.getZOnSide(k, side));
    }

    public static int getBlockIdOnSide(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return world.func_72798_a(MiscTools.getXOnSide(x, side), MiscTools.getYOnSide(y, side), MiscTools.getZOnSide(z, side));
    }

    public static TileEntity getBlockTileEntityOnSide(World world, int x, int y, int z, ForgeDirection side) {
        int sz;
        int sy;
        int sx = MiscTools.getXOnSide(x, side);
        if (world.func_72899_e(sx, sy = MiscTools.getYOnSide(y, side), sz = MiscTools.getZOnSide(z, side))) {
            return world.func_72796_p(sx, sy, sz);
        }
        return null;
    }

    public static TileEntity getBlockTileEntityOnSide(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int sx = MiscTools.getXOnSide(x, side);
        int sy = MiscTools.getYOnSide(y, side);
        int sz = MiscTools.getZOnSide(z, side);
        return world.func_72796_p(sx, sy, sz);
    }

    public static boolean areCoordinatesOnSide(int x, int y, int z, ForgeDirection side, int xCoord, int yCoord, int zCoord) {
        return x + side.offsetX == xCoord && y + side.offsetY == yCoord && z + side.offsetZ == zCoord;
    }

    public static void notifyBlocksOfNeighborChangeOnSide(World world, int i, int j, int k, int blockID, ForgeDirection side) {
        world.func_72898_h(MiscTools.getXOnSide(i, side), MiscTools.getYOnSide(j, side), MiscTools.getZOnSide(k, side), blockID);
    }
}

