/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.Locale;
import java.util.Random;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.worldgen.WorldGenGeode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class GeodePopulator {
    public static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"RAILCRAFT_GEODE", (Class[])new Class[0], (Object[])new Object[0]);
    public static final int MIN_DEPTH = 15;
    private static GeodePopulator instance;
    private final WorldGenerator geode = new WorldGenGeode(BlockCube.getBlock(), EnumCube.ABYSSAL_STONE.ordinal());

    public static GeodePopulator instance() {
        if (instance == null) {
            instance = new GeodePopulator();
        }
        return instance;
    }

    private GeodePopulator() {
    }

    @ForgeSubscribe
    public void generate(PopulateChunkEvent.Pre event) {
        if (!TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE)) {
            return;
        }
        this.generateGeode(event.world, event.rand, event.chunkX, event.chunkZ);
    }

    public void generateGeode(World world, Random rand, int chunkX, int chunkZ) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        if (this.canGen(world, rand, x, z)) {
            int y = 16 + rand.nextInt(16);
            this.geode.func_76484_a(world, rand, x, y, z);
        }
    }

    private boolean canGen(World world, Random rand, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            return false;
        }
        if (biome.field_76791_y == null || biome.field_76791_y.toLowerCase(Locale.ENGLISH).contains("river")) {
            return false;
        }
        return rand.nextDouble() <= 0.3 && this.isWaterDeep(world, x, z, 15);
    }

    private boolean isWaterDeep(World world, int x, int z, int minDepth) {
        Chunk chunk = world.func_72938_d(x, z);
        int trimmedX = x & 0xF;
        int trimmedZ = z & 0xF;
        int depth = 0;
        for (int y = chunk.func_76625_h() + 15; y > 0; --y) {
            int blockId = chunk.func_76610_a(trimmedX, y, trimmedZ);
            Block block = Block.field_71973_m[blockId];
            if (blockId == 0) continue;
            if (block.field_72018_cp == Material.field_76244_g) {
                ++depth;
            }
            if (depth < minDepth) continue;
            return true;
        }
        return false;
    }
}

