/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.integration.minefactoryreloaded;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;

public class Harvestable
implements IFactoryHarvestable {
    private int sourceId;
    private HarvestType harvestType;

    public Harvestable(int sourceId, HarvestType harvestType) {
        if (sourceId > Block.field_71973_m.length) {
            throw new IllegalArgumentException("Passed an Item ID to FactoryHarvestableStandard's source block argument");
        }
        this.sourceId = sourceId;
        this.harvestType = harvestType;
    }

    public int getPlantId() {
        return this.sourceId;
    }

    public HarvestType getHarvestType() {
        return this.harvestType;
    }

    public boolean breakBlock() {
        return true;
    }

    public boolean canBeHarvested(World world, Map<String, Boolean> harvesterSettings, int x, int y, int z) {
        return true;
    }

    public List<ItemStack> getDrops(World world, Random rand, Map<String, Boolean> harvesterSettings, int x, int y, int z) {
        if (harvesterSettings.get("silkTouch") != null && harvesterSettings.get("silkTouch").booleanValue() && this.harvestType == HarvestType.TreeLeaf) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack(this.sourceId, 1, world.func_72805_g(x, y, z)));
            return drops;
        }
        return Block.field_71973_m[this.getPlantId()].getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0);
    }

    public void preHarvest(World world, int x, int y, int z) {
    }

    public void postHarvest(World world, int x, int y, int z) {
    }
}

