/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.integration.ArrayCommons;
import mrtjp.projectred.integration.SimpleGatePart;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.WirePropogator;

public class RowGatePart
extends SimpleGatePart
implements IRedwirePart,
ArrayCommons.ITopArrayWire {
    public static Cuboid6[][] oBoxes = new Cuboid6[6][2];
    public static Cuboid6[] cBoxes = new Cuboid6[6];
    public byte signal;

    @Override
    public String getType() {
        return "pr_rgate";
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("signal", this.signal);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.signal = tag.c("signal");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.signal = packet.readByte();
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 11) {
            this.signal = packet.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else {
            super.read(packet, switch_key);
        }
    }

    @Override
    public void updateAndPropogate(TMultiPart prev, int mode) {
        int wireMask = this.wireMask(prev);
        if ((wireMask & 2) != 0) {
            this._updateAndPropogate(prev, mode);
        } else {
            WirePropogator.addNeighborChange(new BlockCoord((asp)this.tile()));
        }
    }

    private void _updateAndPropogate(TMultiPart prev, int mode) {
        int oldSignal = this.signal & 0xFF;
        if (mode == 1 && oldSignal == 0) {
            return;
        }
        int newSignal = this.calculateSignal();
        if (newSignal < oldSignal) {
            if (newSignal > 0) {
                WirePropogator.propogateAnalogDrop(this);
            }
            this.signal = 0;
            this.propogate(prev, 1);
        } else if (newSignal > oldSignal) {
            this.signal = (byte)newSignal;
            if (mode == 1) {
                this.propogate(null, 0);
            } else {
                this.propogate(prev, 0);
            }
        } else if (mode == 1) {
            this.propogateTo(prev, 0);
        } else if (mode == 2) {
            this.propogate(prev, 3);
        }
    }

    public int calculateSignal() {
        WirePropogator.setWiresProvidePower(false);
        WirePropogator.redwiresProvidePower = false;
        int s = 0;
        int i = 0;
        for (int r = 0; r < 4; ++r) {
            if (this.toInternal(r) % 2 == 0 || (i = (this.connMap & 1 << r) != 0 ? this.calculateCornerSignal(r) : this.calculateStraightSignal(r)) <= s) continue;
            s = i;
        }
        WirePropogator.setWiresProvidePower(true);
        WirePropogator.redwiresProvidePower = true;
        return s;
    }

    @Override
    public int calculateCornerSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord cnrPos = new BlockCoord((asp)this.tile()).offset(absDir);
        BlockCoord pos = cnrPos.copy().offset(this.side());
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            return this.getPartSignal(t.partMap(absDir ^ 1), Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side() ^ 1)));
        }
        return 0;
    }

    @Override
    public int calculateStraightSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        int s = 0;
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null && (this.connMap & 16 << r) != 0) {
            TMultiPart tp = t.partMap(this.side());
            if (tp != null) {
                s = this.getPartSignal(tp, (r + 2) % 4);
            }
        } else {
            int blockID = this.world().a(pos.x, pos.y, pos.z);
            if (blockID == aqz.aA.cF) {
                return this.world().h(pos.x, pos.y, pos.z) - 1;
            }
        }
        int i = this.calculateRedstoneSignal(r);
        if (i > s) {
            s = i;
        }
        return s;
    }

    @Override
    public int calculateRedstoneSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        int i = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)absDir) * 17;
        if (i > 0) {
            return i;
        }
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        return this.world().l(pos.x, pos.y, pos.z, absDir) * 17;
    }

    @Override
    public int getPartSignal(TMultiPart part, int r) {
        if (part instanceof IRedwirePart && ((IRedwirePart)part).isWireSide(r)) {
            return ((IRedwirePart)part).getRedwireSignal(r) - 1;
        }
        if (part instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)part).getRedwireSignal(r);
        }
        return 0;
    }

    @Override
    public void onSignalUpdate() {
        this.tile().markDirty();
        super.onChange();
        this.getWriteStream(11).writeByte((int)this.signal);
    }

    public void propogate(TMultiPart prev, int mode) {
        if (mode != 3) {
            WirePropogator.addPartChange((TMultiPart)this);
        }
        for (int r = 0; r < 4; ++r) {
            if (this.toInternal(r) % 2 == 0) continue;
            if ((this.connMap & 1 << r) != 0) {
                this.propogateCorner(r, prev, mode);
                continue;
            }
            this.propogateStraight(r, prev, mode);
        }
    }

    public void propogateCorner(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir).offset(this.side());
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap(absDir ^ 1);
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(pos);
    }

    public void propogateStraight(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap(this.side());
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(pos);
    }

    public int wireMask(TMultiPart propogator) {
        if (propogator.tile() == null) {
            return 3;
        }
        if (this.sideDiff(propogator) == Rotation.rotateSide((int)this.side(), (int)this.toAbsolute(0)) >> 1) {
            return 1;
        }
        return 2;
    }

    public int sideDiff(TMultiPart part) {
        int a = this.side() >> 1;
        if (a != 0 && this.y() != part.y()) {
            return 0;
        }
        if (a != 1 && this.z() != part.z()) {
            return 1;
        }
        return 2;
    }

    public boolean propogateTo(TMultiPart part, int mode) {
        if (part instanceof IWirePart) {
            WirePropogator.propogateTo((IWirePart)part, (TMultiPart)this, mode);
            return true;
        }
        return false;
    }

    @Override
    public int getRedwireSignal(int side) {
        int r = this.toInternal(side);
        return r % 2 == 0 ? this.getLogic().getOutput(this, r) * 17 : this.signal & 0xFF;
    }

    @Override
    public void onChange() {
        super.onChange();
        WirePropogator.propogateTo(this, 0);
    }

    @Override
    public boolean canConnectRedstone(int side) {
        if ((side & 6) == (this.side() & 6)) {
            return false;
        }
        int r = this.relRot(side);
        if (r % 2 != 0) {
            return true;
        }
        return this.getLogic().canConnect(this, r);
    }

    @Override
    public int weakPowerLevel(int side) {
        if ((side & 6) == (this.side() & 6)) {
            return 0;
        }
        int r = this.relRot(side);
        if (r % 2 != 0) {
            return this.rsLevel(this.signal & 0xFF);
        }
        return super.weakPowerLevel(side);
    }

    public int rsLevel(int i) {
        if (WirePropogator.redwiresProvidePower) {
            return (i + 16) / 17;
        }
        return 0;
    }

    @Override
    public boolean isWireSide(int side) {
        if (side < 0) {
            return false;
        }
        return this.toInternal(side) % 2 != 0;
    }

    @Override
    public Cuboid6 getBounds() {
        return cBoxes[this.side()];
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(oBoxes[this.side()]);
    }

    static {
        RowGatePart.oBoxes[0][0] = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.75, 1.0);
        RowGatePart.oBoxes[0][1] = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.75, 0.875);
        RowGatePart.cBoxes[0] = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        for (int s = 1; s < 6; ++s) {
            Transformation t = Rotation.sideRotations[s].at(Vector3.center);
            RowGatePart.oBoxes[s][0] = oBoxes[0][0].copy().apply(t);
            RowGatePart.oBoxes[s][1] = oBoxes[0][1].copy().apply(t);
            RowGatePart.cBoxes[s] = cBoxes[0].copy().apply(t);
        }
    }
}

