/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import resonant.lib.utility.nbt.NBTUtility;
import resonantinduction.electrical.encoder.coding.ILogicTask;
import resonantinduction.electrical.encoder.coding.IProgram;
import resonantinduction.electrical.encoder.coding.IProgrammableMachine;
import resonantinduction.electrical.encoder.coding.ITask;
import resonantinduction.electrical.encoder.coding.TaskRegistry;
import universalelectricity.api.vector.Vector2;

public class Program
implements IProgram {
    protected Vector2 currentPos = new Vector2(0.0, 0.0);
    protected ITask currentTask;
    protected IProgrammableMachine machine;
    protected HashMap<Vector2, ITask> tasks = new HashMap();
    protected HashMap<String, Object> varables = new HashMap();
    protected int width = 0;
    protected int hight = 0;
    boolean editing = false;

    @Override
    public void init(IProgrammableMachine machine) {
        this.machine = machine;
        int w = 0;
        int h = 0;
        ArrayList<Vector2> removeList = new ArrayList<Vector2>();
        for (Map.Entry<Vector2, ITask> entry : this.tasks.entrySet()) {
            if (entry.getValue() != null) {
                entry.getValue().setProgram(this);
                if (entry.getValue().getCol() > w) {
                    w = entry.getValue().getCol();
                }
                if (entry.getValue().getRow() <= h) continue;
                h = entry.getValue().getRow();
                continue;
            }
            removeList.add(entry.getKey());
        }
        for (Vector2 vec : removeList) {
            this.tasks.remove(vec);
        }
        this.width = w;
        this.hight = h;
    }

    @Override
    public IProgrammableMachine getMachine() {
        return this.machine;
    }

    @Override
    public HashMap<String, Object> getDeclairedVarables() {
        return this.varables;
    }

    @Override
    public ITask getNextTask() {
        if (this.currentTask != null) {
            this.currentTask.reset();
        }
        this.currentTask = this.getTaskAt(this.currentPos.intX(), this.currentPos.intY());
        this.currentPos.add(new Vector2(0.0, 1.0));
        if (this.currentTask != null) {
            this.currentTask.refresh();
        }
        if (this.currentTask instanceof ILogicTask && ((ILogicTask)this.currentTask).getExitPoint() != null) {
            this.currentTask = ((ILogicTask)this.currentTask).getExitPoint();
            this.currentPos = new Vector2((double)this.currentTask.getCol(), (double)(this.currentTask.getRow() + 1));
        }
        return this.currentTask;
    }

    @Override
    public ITask getTaskAt(int col, int row) {
        return this.tasks.get(new Vector2((double)col, (double)row));
    }

    @Override
    public HashMap<Vector2, ITask> getTaskMap() {
        return this.tasks;
    }

    @Override
    public void setTaskAt(int col, int row, ITask task) {
        if (!this.editing) {
            if (task != null) {
                task.setPosition(col, row);
                if (task.getCol() > this.width) {
                    this.width = task.getCol();
                }
                if (task.getRow() > this.hight) {
                    this.hight = task.getRow();
                }
                this.tasks.put(new Vector2((double)col, (double)row), task);
            } else if (this.tasks.containsKey(new Vector2((double)col, (double)row))) {
                this.tasks.remove(new Vector2((double)col, (double)row));
                if (col == this.hight && !this.isThereATaskInRow(this.hight)) {
                    --this.hight;
                } else if (!this.isThereATaskInRow(col)) {
                    this.moveAll(col, true);
                }
            }
        }
    }

    public boolean isThereATaskInRow(int row) {
        int colume = 0;
        for (int x = 0; x <= this.width; ++x) {
            if (this.getTaskAt(colume, row) != null) {
                return true;
            }
            ++colume;
        }
        return false;
    }

    public boolean isThereATaskInColume(int colume) {
        int row = 0;
        for (int y = 0; y <= this.width; ++y) {
            if (this.getTaskAt(row, colume) != null) {
                return true;
            }
            ++row;
        }
        return false;
    }

    public void moveAll(int row, boolean up) {
        if (!this.editing) {
            this.editing = true;
            ArrayList<ITask> moveList = new ArrayList<ITask>();
            int move = up ? -1 : 1;
            for (int x = 0; x <= this.width; ++x) {
                for (int y = row; y <= this.hight; ++y) {
                    Vector2 targetPos = new Vector2((double)x, (double)y);
                    ITask tagetTask = this.getTaskAt(x, y);
                    if (tagetTask == null) continue;
                    moveList.add(tagetTask);
                    this.tasks.remove(targetPos);
                }
            }
            for (ITask moveTask : moveList) {
                this.setTaskAt(moveTask.getCol(), moveTask.getRow() + move, moveTask);
            }
            this.editing = false;
        }
    }

    @Override
    public void insertTask(int col, int row, ITask task) {
        if (task != null && !this.editing) {
            if (this.getTaskAt(col, row) != null) {
                this.moveAll(row, false);
                this.setTaskAt(col, row, task);
            } else {
                this.setTaskAt(col, row, task);
            }
        }
    }

    @Override
    public void reset() {
        if (this.currentTask != null) {
            this.currentTask.reset();
        }
        this.currentPos = new Vector2(0.0, 0.0);
    }

    @Override
    public void setVar(String name, Object object) {
        if (name != null) {
            if (object != null) {
                this.varables.put(name, object);
            } else {
                this.varables.remove(name);
            }
        }
    }

    @Override
    public Object getVar(String name) {
        return this.varables.get(name);
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        NBTTagList taskList = new NBTTagList();
        for (Map.Entry<Vector2, ITask> entry : this.tasks.entrySet()) {
            entry.getValue().setPosition(entry.getKey().intX(), entry.getKey().intY());
            NBTTagCompound task = new NBTTagCompound();
            entry.getValue().save(task);
            if (this.currentTask != null && entry.getKey().equals((Object)new Vector2((double)this.currentTask.getCol(), (double)this.currentTask.getRow()))) {
                task.func_74757_a("currentTask", true);
                entry.getValue().saveProgress(task);
            }
            task.func_74778_a("methodName", entry.getValue().getMethodName());
            taskList.func_74742_a((NBTBase)task);
        }
        nbt.func_74782_a("tasks", (NBTBase)taskList);
        taskList = new NBTTagList();
        for (Map.Entry<Object, Object> entry : this.varables.entrySet()) {
            taskList.func_74742_a((NBTBase)NBTUtility.saveObject((String)((String)entry.getKey()), (Object)entry.getValue()));
        }
        nbt.func_74782_a("vars", (NBTBase)taskList);
        return nbt;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        NBTTagCompound tag;
        int s;
        NBTTagList taskList = nbt.func_74761_m("tasks");
        for (s = 0; s < taskList.func_74745_c(); ++s) {
            tag = (NBTTagCompound)taskList.func_74743_b(s);
            if (!tag.func_74764_b("methodName")) continue;
            ITask task = TaskRegistry.getCommand(tag.func_74779_i("methodName"));
            if (task != null) {
                if ((task = task.clone()) == null) continue;
                task.load(tag);
                if (tag.func_74767_n("currentTask")) {
                    this.currentTask = task;
                    task.loadProgress(tag);
                    this.currentPos = new Vector2((double)task.getCol(), (double)task.getRow());
                }
                this.tasks.put(new Vector2((double)task.getCol(), (double)task.getRow()), task);
                if (task.getCol() > this.width) {
                    this.width = task.getCol();
                }
                if (task.getRow() <= this.hight) continue;
                this.hight = task.getRow();
                continue;
            }
            System.out.println("[CoreMachine]Error: failed to load task " + tag.func_74779_i("methodName"));
        }
        taskList = nbt.func_74761_m("vars");
        for (s = 0; s < taskList.func_74745_c(); ++s) {
            tag = (NBTTagCompound)taskList.func_74743_b(s);
            this.varables.put(tag.func_74740_e(), NBTUtility.loadObject((NBTTagCompound)tag, (String)tag.func_74740_e()));
        }
    }

    public Program clone() {
        Program program = new Program();
        program.load(this.save(new NBTTagCompound()));
        program.reset();
        return program;
    }

    @Override
    public Vector2 getSize() {
        return new Vector2((double)this.width, (double)this.hight);
    }
}

