/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import resonant.lib.utility.nbt.NBTUtility;
import resonantinduction.core.ArgumentData;
import resonantinduction.electrical.encoder.coding.IProgram;
import resonantinduction.electrical.encoder.coding.IProgrammableMachine;
import resonantinduction.electrical.encoder.coding.ITask;
import universalelectricity.api.vector.Vector2;

public abstract class TaskBase
implements ITask {
    protected IProgram program;
    protected String methodName;
    protected long ticks;
    protected ITask.TaskType taskType;
    protected int col;
    protected int row;
    protected Vector2 UV;
    protected List<ArgumentData> args = new ArrayList<ArgumentData>();

    public TaskBase(String name, ITask.TaskType tasktype) {
        this.methodName = name;
        this.taskType = tasktype;
        this.UV = this.taskType.UV;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void setProgram(IProgram program) {
        this.program = program;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public void setPosition(int col, int row) {
        this.col = col;
        this.row = row;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public ITask.TaskType getType() {
        return this.taskType;
    }

    @Override
    public Object getArg(String name) {
        if (this.getArgs() != null) {
            for (ArgumentData arg : this.getArgs()) {
                if (!arg.getName().equalsIgnoreCase(name)) continue;
                return arg.getData();
            }
        }
        return null;
    }

    @Override
    public void setArg(String argName, Object obj) {
        if (this.getArgs() != null) {
            for (ArgumentData arg : this.getArgs()) {
                if (!arg.getName().equalsIgnoreCase(argName)) continue;
                arg.setData(obj);
                break;
            }
        }
    }

    @Override
    public List<ArgumentData> getArgs() {
        return this.args;
    }

    @Override
    public abstract TaskBase clone();

    public void load(NBTTagCompound nbt) {
        this.col = nbt.func_74762_e("col");
        this.row = nbt.func_74762_e("row");
        if (this.getArgs() != null) {
            NBTTagCompound parms = nbt.func_74775_l("args");
            for (ArgumentData arg : this.getArgs()) {
                Object obj;
                if (!arg.isValid(obj = NBTUtility.loadObject((NBTTagCompound)parms, (String)arg.getName()))) continue;
                arg.setData(obj);
            }
        }
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74768_a("col", this.col);
        nbt.func_74768_a("row", this.row);
        NBTTagCompound parms = new NBTTagCompound();
        for (ArgumentData arg : this.getArgs()) {
            NBTUtility.saveObject((NBTTagCompound)parms, (String)arg.getName(), (Object)arg.getData());
        }
        nbt.func_74766_a("args", parms);
    }

    @Override
    public ITask loadProgress(NBTTagCompound nbt) {
        return this;
    }

    @Override
    public NBTTagCompound saveProgress(NBTTagCompound nbt) {
        return nbt;
    }

    @Override
    public boolean canUseTask(IProgrammableMachine device) {
        return false;
    }

    public String toString() {
        return "Task[" + this.methodName + "]:";
    }

    @Override
    public ResourceLocation getTextureSheet() {
        return ITask.TaskType.TEXTURE;
    }

    @Override
    public Vector2 getTextureUV() {
        return this.UV;
    }

    @Override
    public void getToolTips(List<String> list) {
        list.add(this.getMethodName());
    }
}

