/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.lib.type.Pair;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.armbot.TaskBaseArmbot;
import resonantinduction.electrical.armbot.TaskBaseProcess;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.ITask;
import universalelectricity.api.vector.Vector3;

public class TaskBreak
extends TaskBaseArmbot {
    protected int breakTicks = 30;
    protected boolean keep = false;

    public TaskBreak() {
        this("break");
    }

    public TaskBreak(String name) {
        super(name);
    }

    @Override
    public IProcessTask.ProcessReturn onUpdate() {
        if (super.onUpdate() == IProcessTask.ProcessReturn.CONTINUE) {
            Vector3 serachPosition = ((IArmbot)this.program.getMachine()).getHandPos();
            Pair<World, Vector3> location = this.program.getMachine().getLocation();
            Block block = Block.field_71973_m[serachPosition.getBlockID((IBlockAccess)location.left())];
            --this.breakTicks;
            if (block != null && this.breakTicks <= 0) {
                ArrayList items = block.getBlockDropped((World)location.left(), serachPosition.intX(), serachPosition.intY(), serachPosition.intZ(), serachPosition.getBlockMetadata((IBlockAccess)location.left()), 0);
                if (!this.keep || items.size() > 1) {
                    InventoryUtility.dropBlockAsItem((World)((World)location.left()), (Vector3)serachPosition);
                } else {
                    ((IArmbot)this.program.getMachine()).grabObject(new EntityItem((World)location.left(), (double)serachPosition.intX() + 0.5, (double)serachPosition.intY() + 0.5, (double)serachPosition.intZ() + 0.5, (ItemStack)items.get(0)));
                }
                ((World)location.left()).func_72832_d(serachPosition.intX(), serachPosition.intY(), serachPosition.intZ(), 0, 0, 3);
                return IProcessTask.ProcessReturn.DONE;
            }
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public TaskBaseProcess clone() {
        return new TaskBreak();
    }

    @Override
    public ITask loadProgress(NBTTagCompound nbt) {
        this.breakTicks = nbt.func_74762_e("breakTicks");
        return this;
    }

    @Override
    public NBTTagCompound saveProgress(NBTTagCompound nbt) {
        nbt.func_74768_a("breakTicks", this.breakTicks);
        return nbt;
    }
}

