/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import resonantinduction.electrical.armbot.TaskBase;
import resonantinduction.electrical.encoder.coding.IRedirectTask;
import resonantinduction.electrical.encoder.coding.ITask;
import universalelectricity.api.vector.Vector2;

public class TaskGOTO
extends TaskBase
implements IRedirectTask {
    protected ITask task;
    protected Vector2 taskPos;
    protected boolean render = true;
    protected List<Vector2> exits = new ArrayList<Vector2>();

    public TaskGOTO() {
        super("GoTo", ITask.TaskType.DECISION);
    }

    public TaskGOTO(int x, int y) {
        this();
        this.taskPos = new Vector2((double)x, (double)y);
    }

    public TaskGOTO(boolean render) {
        this();
        this.render = render;
    }

    @Override
    public ITask getExitPoint() {
        return this.task;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.task == null && this.taskPos != null) {
            this.task = this.program.getTaskAt(this.taskPos.intX(), this.taskPos.intY());
        }
        this.exits.clear();
        if (this.task != null) {
            this.exits.add(new Vector2((double)this.task.getCol(), (double)this.task.getRow()));
        }
    }

    @Override
    public void setExitPoint(int i, ITask task) {
        if (i == 0) {
            this.task = task;
        }
    }

    public void setExitPoint(int i, Vector2 vector2) {
        if (i == 0) {
            this.taskPos = vector2;
        }
    }

    @Override
    public int getMaxExitPoints() {
        return 1;
    }

    @Override
    public boolean render() {
        return this.render;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.loadProgress(nbt);
        this.taskPos = new Vector2(nbt.func_74769_h("entryX"), nbt.func_74769_h("entryY"));
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.saveProgress(nbt);
        if (this.task != null) {
            nbt.func_74780_a("entryX", (double)this.task.getCol());
            nbt.func_74780_a("entryY", (double)this.task.getRow());
        }
    }

    @Override
    public TaskBase clone() {
        return new TaskGOTO();
    }

    @Override
    public List<Vector2> getExits() {
        return this.exits;
    }
}

