/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import resonant.api.ai.EntitySettings;
import resonantinduction.core.ArgumentData;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.armbot.TaskBaseProcess;
import resonantinduction.electrical.armbot.task.TaskGrabPrefab;
import resonantinduction.electrical.encoder.coding.IProcessTask;

public class TaskGrabEntity
extends TaskGrabPrefab {
    public boolean child = false;
    private Class<? extends Entity> entityToInclude;

    public TaskGrabEntity() {
        super("Grab-Entity");
        this.args.add(new ArgumentData("child", (Object)false));
    }

    @Override
    public IProcessTask.ProcessReturn onMethodCalled() {
        if (super.onMethodCalled() == IProcessTask.ProcessReturn.CONTINUE) {
            this.entityToInclude = Entity.class;
            try {
                if (this.getArg("Entity") instanceof Class) {
                    this.entityToInclude = (Class)this.getArg("Entity");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getArg("child") instanceof Boolean) {
                this.child = (Boolean)this.getArg("child");
            }
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public IProcessTask.ProcessReturn onUpdate() {
        if (super.onUpdate() == IProcessTask.ProcessReturn.CONTINUE) {
            if (((IArmbot)this.program.getMachine()).getHeldObject() != null) {
                return IProcessTask.ProcessReturn.DONE;
            }
            List found = ((World)this.program.getMachine().getLocation().left()).func_72872_a(this.entityToInclude, AxisAlignedBB.func_72330_a((double)(this.armPos.x - 0.5), (double)(this.armPos.y - 0.5), (double)(this.armPos.z - 0.5), (double)(this.armPos.x + 0.5), (double)(this.armPos.y + 0.5), (double)(this.armPos.z + 0.5)));
            if (found != null && found.size() > 0) {
                for (Entity entity : found) {
                    if (entity == null || entity instanceof EntityArrow || entity instanceof EntityPlayer || entity instanceof EntityAgeable && (!(entity instanceof EntityAgeable) || this.child != ((EntityAgeable)entity).func_70631_g_())) continue;
                    ((IArmbot)this.program.getMachine()).grabObject(entity);
                    if (this.belt != null) {
                        this.belt.ignoreEntity(entity);
                    }
                    return IProcessTask.ProcessReturn.DONE;
                }
            }
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public void load(NBTTagCompound taskCompound) {
        super.loadProgress(taskCompound);
        this.child = taskCompound.func_74767_n("child");
        this.entityToInclude = EntitySettings.get((String)taskCompound.func_74779_i("name"));
    }

    @Override
    public void save(NBTTagCompound taskCompound) {
        super.saveProgress(taskCompound);
        taskCompound.func_74757_a("child", this.child);
        taskCompound.func_74778_a("name", this.entityToInclude != null ? EntitySettings.get(this.entityToInclude) : "");
    }

    @Override
    public String toString() {
        String baby = "";
        String entity = "";
        if (this.entityToInclude != null) {
            entity = EntitySettings.get(this.entityToInclude);
            if (this.child) {
                baby = "baby ";
            }
        }
        return "GRAB " + baby + entity;
    }

    @Override
    public TaskBaseProcess clone() {
        return new TaskGrabEntity();
    }
}

