/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.ArrayList;
import java.util.List;
import resonantinduction.core.ArgumentData;
import resonantinduction.electrical.armbot.TaskBaseLogic;
import resonantinduction.electrical.encoder.coding.IProgrammableMachine;
import resonantinduction.electrical.encoder.coding.ITask;
import universalelectricity.api.vector.Vector2;

public class TaskIF
extends TaskBaseLogic {
    protected ITask exitTruePoint = null;
    protected ITask exitFalsePoint = null;
    protected List<Vector2> exits = new ArrayList<Vector2>();
    protected boolean isTrue = false;

    public TaskIF() {
        super("IF");
        this.args.add(new ArgumentData("check", (Object)"statement"));
        this.args.add(new ArgumentData("compare", (Object)"statement"));
        this.UV = new Vector2(0.0, 120.0);
    }

    public TaskIF(ITask trueExit, ITask falseExit) {
        this();
        this.exitTruePoint = trueExit;
        this.exitFalsePoint = falseExit;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.getArg("check") != null && this.getArg("compare") != null) {
            this.isTrue = this.getArg("check").equals(this.getArg("compare"));
        }
        if (this.exitTruePoint == null) {
            this.exitTruePoint = this.program.getTaskAt(this.getCol() + 1, this.getRow());
        }
        if (this.exitFalsePoint == null) {
            this.exitFalsePoint = this.program.getTaskAt(this.getCol(), this.getRow() + 1);
        }
    }

    @Override
    public TaskIF clone() {
        return new TaskIF();
    }

    @Override
    public ITask getExitPoint() {
        if (this.isTrue) {
            return this.exitTruePoint;
        }
        return this.exitFalsePoint;
    }

    @Override
    public int getMaxExitPoints() {
        return 2;
    }

    @Override
    public void setExitPoint(int i, ITask task) {
        if (i == 0) {
            this.exitFalsePoint = task;
        } else if (i == 1) {
            this.exitTruePoint = task;
        }
    }

    @Override
    public boolean canUseTask(IProgrammableMachine device) {
        return true;
    }

    @Override
    public List<Vector2> getExits() {
        return this.exits;
    }
}

