/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import resonant.lib.science.units.UnitHelper;
import resonantinduction.core.ArgumentData;
import resonantinduction.electrical.armbot.TaskBaseProcess;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.IProgrammableMachine;

public class TaskIdle
extends TaskBaseProcess {
    public int idleTime = 80;
    private int totalIdleTime = 80;

    public TaskIdle() {
        super("wait");
        this.args.add(new ArgumentData("idleTime", (Object)20));
    }

    @Override
    public IProcessTask.ProcessReturn onMethodCalled() {
        if (super.onMethodCalled() == IProcessTask.ProcessReturn.CONTINUE) {
            if (UnitHelper.tryToParseInt((Object)this.getArg("idleTime")) > 0) {
                this.totalIdleTime = this.idleTime = UnitHelper.tryToParseInt((Object)this.getArg("idleTime"));
                return IProcessTask.ProcessReturn.CONTINUE;
            }
            return IProcessTask.ProcessReturn.ARGUMENT_ERROR;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public IProcessTask.ProcessReturn onUpdate() {
        if (this.idleTime > 0) {
            --this.idleTime;
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.DONE;
    }

    @Override
    public void load(NBTTagCompound taskCompound) {
        super.load(taskCompound);
        this.totalIdleTime = taskCompound.func_74762_e("idleTotal");
    }

    @Override
    public void save(NBTTagCompound taskCompound) {
        super.save(taskCompound);
        taskCompound.func_74768_a("idleTotal", this.totalIdleTime);
    }

    @Override
    public TaskBaseProcess loadProgress(NBTTagCompound taskCompound) {
        super.loadProgress(taskCompound);
        this.idleTime = taskCompound.func_74762_e("idleTime");
        return this;
    }

    @Override
    public NBTTagCompound saveProgress(NBTTagCompound taskCompound) {
        super.saveProgress(taskCompound);
        taskCompound.func_74768_a("idleTime", this.idleTime);
        return taskCompound;
    }

    @Override
    public String toString() {
        return super.toString() + " " + Integer.toString(this.totalIdleTime);
    }

    @Override
    public TaskBaseProcess clone() {
        return new TaskIdle();
    }

    @Override
    public boolean canUseTask(IProgrammableMachine device) {
        return true;
    }

    @Override
    public void getToolTips(List<String> list) {
        super.getToolTips(list);
        list.add(" Wait: " + this.totalIdleTime);
    }
}

