/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import resonant.lib.science.units.UnitHelper;
import resonant.lib.utility.MathUtility;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.armbot.TaskBaseArmbot;
import resonantinduction.electrical.armbot.TaskBaseProcess;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.args.ArgumentIntData;
import universalelectricity.api.vector.Vector2;

public class TaskRotateTo
extends TaskBaseArmbot {
    int targetRotationYaw = 0;
    int targetRotationPitch = 0;

    public TaskRotateTo() {
        this(0, 0);
    }

    public TaskRotateTo(int yaw, int pitch) {
        this("RotateTo", yaw, pitch);
    }

    public TaskRotateTo(String string, int yaw, int pitch) {
        super(string);
        this.args.add(new ArgumentIntData("yaw", yaw, 360, 0));
        this.args.add(new ArgumentIntData("pitch", pitch, 360, 0));
        this.UV = new Vector2(100.0, 80.0);
    }

    @Override
    public IProcessTask.ProcessReturn onMethodCalled() {
        if (super.onMethodCalled() == IProcessTask.ProcessReturn.CONTINUE) {
            this.targetRotationYaw = (int)MathUtility.clampAngleTo360((float)UnitHelper.tryToParseInt((Object)this.getArg("yaw")));
            this.targetRotationPitch = (int)MathUtility.clampAngleTo360((float)UnitHelper.tryToParseInt((Object)this.getArg("pitch")));
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public IProcessTask.ProcessReturn onUpdate() {
        if (super.onUpdate() == IProcessTask.ProcessReturn.CONTINUE) {
            ((IArmbot)this.program.getMachine()).moveArmTo(this.targetRotationYaw, this.targetRotationPitch);
            return ((IArmbot)this.program.getMachine()).getRotation().intX() != this.targetRotationYaw || ((IArmbot)this.program.getMachine()).getRotation().intY() != this.targetRotationPitch ? IProcessTask.ProcessReturn.CONTINUE : IProcessTask.ProcessReturn.DONE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public String toString() {
        return super.toString() + " Yaw:" + Integer.toString(this.targetRotationYaw) + " Pitch:" + Integer.toString(this.targetRotationPitch);
    }

    @Override
    public void load(NBTTagCompound taskCompound) {
        super.load(taskCompound);
        this.targetRotationPitch = taskCompound.func_74762_e("rotPitch");
        this.targetRotationYaw = taskCompound.func_74762_e("rotYaw");
    }

    @Override
    public void save(NBTTagCompound taskCompound) {
        super.save(taskCompound);
        taskCompound.func_74768_a("rotPitch", this.targetRotationPitch);
        taskCompound.func_74768_a("rotYaw", this.targetRotationYaw);
    }

    @Override
    public TaskBaseProcess clone() {
        return new TaskRotateTo();
    }

    @Override
    public void getToolTips(List<String> list) {
        super.getToolTips(list);
        list.add(" Yaw:   " + this.targetRotationYaw);
        list.add(" Pitch: " + this.targetRotationPitch);
    }
}

