/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.science.units.UnitHelper;
import resonant.lib.utility.MathUtility;
import resonant.lib.utility.inventory.InternalInventoryHandler;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.armbot.TaskBaseArmbot;
import resonantinduction.electrical.armbot.TaskBaseProcess;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.args.ArgumentIntData;
import universalelectricity.api.vector.Vector2;
import universalelectricity.api.vector.Vector3;

public class TaskTake
extends TaskBaseArmbot {
    protected ItemStack stack;
    protected int ammount = -1;

    public TaskTake() {
        super("Take");
        this.args.add(new ArgumentIntData("blockID", -1, Block.field_71973_m.length - 1, -1));
        this.args.add(new ArgumentIntData("blockMeta", -1, 15, -1));
        this.args.add(new ArgumentIntData("stackSize", -1, 64, -1));
        this.UV = new Vector2(40.0, 80.0);
    }

    @Override
    public IProcessTask.ProcessReturn onMethodCalled() {
        if (super.onMethodCalled() == IProcessTask.ProcessReturn.CONTINUE) {
            this.ammount = UnitHelper.tryToParseInt((Object)this.getArg("stackSize"), (int)-1);
            int blockID = UnitHelper.tryToParseInt((Object)this.getArg("blockID"), (int)-1);
            int blockMeta = UnitHelper.tryToParseInt((Object)this.getArg("blockMeta"), (int)Short.MAX_VALUE);
            if (blockID > 0) {
                this.stack = new ItemStack(blockID, this.ammount <= 0 ? 1 : this.ammount, blockMeta == -1 ? Short.MAX_VALUE : blockMeta);
            }
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public IProcessTask.ProcessReturn onUpdate() {
        if (super.onUpdate() == IProcessTask.ProcessReturn.CONTINUE) {
            TileEntity targetTile = ((IArmbot)this.program.getMachine()).getHandPos().getTileEntity((IBlockAccess)this.program.getMachine().getLocation().left());
            if (targetTile != null && ((IArmbot)this.program.getMachine()).getHeldObject() instanceof ItemStack) {
                ForgeDirection direction = MathUtility.getFacingDirectionFromAngle((double)((IArmbot)this.program.getMachine()).getRotation().x);
                HashSet<ItemStack> stacks = new HashSet<ItemStack>();
                if (this.stack != null) {
                    stacks.add(this.stack);
                }
                InternalInventoryHandler invEx = new InternalInventoryHandler((World)this.program.getMachine().getLocation().left(), (Vector3)this.program.getMachine().getLocation().right(), stacks, false);
                ((IArmbot)this.program.getMachine()).grabObject(invEx.tryGrabFromPosition(new Vector3(targetTile), direction, this.stack != null ? this.stack.field_77994_a : 1));
                return ((IArmbot)this.program.getMachine()).getHeldObject() != null ? IProcessTask.ProcessReturn.DONE : IProcessTask.ProcessReturn.CONTINUE;
            }
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public String toString() {
        return super.toString() + " " + (this.stack != null ? this.stack.toString() : "1x???@???  ");
    }

    @Override
    public void load(NBTTagCompound taskCompound) {
        super.load(taskCompound);
        this.stack = ItemStack.func_77949_a((NBTTagCompound)taskCompound.func_74775_l("item"));
    }

    @Override
    public void save(NBTTagCompound taskCompound) {
        super.save(taskCompound);
        if (this.stack != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.stack.func_77955_b(tag);
            taskCompound.func_74782_a("item", (NBTBase)tag);
        }
    }

    @Override
    public TaskBaseProcess clone() {
        return new TaskTake();
    }
}

