/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.battery;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import resonant.lib.prefab.block.BlockSidedIO;
import resonant.lib.render.block.BlockRenderingHandler;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.electrical.battery.ItemBlockBattery;
import resonantinduction.electrical.battery.TileBattery;
import resonantinduction.electrical.battery.TileEnergyDistribution;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalElectricity;

public class BlockBattery
extends BlockSidedIO
implements ITileEntityProvider {
    public BlockBattery(int id) {
        super(id, UniversalElectricity.machine);
        this.func_111022_d("resonantinduction:material_metal_side");
    }

    public void func_71861_g(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            TileEnergyDistribution distribution = (TileEnergyDistribution)world.func_72796_p(x, y, z);
            distribution.updateStructure();
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEnergyDistribution) {
            TileEnergyDistribution distribution = (TileEnergyDistribution)tileEntity;
            distribution.updateStructure();
        }
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        if (!world.field_72995_K && itemStack.func_77973_b() instanceof ItemBlockBattery) {
            ItemBlockBattery itemBlock = (ItemBlockBattery)itemStack.func_77973_b();
            TileBattery battery = (TileBattery)world.func_72796_p(x, y, z);
            battery.getEnergyHandler().setCapacity(TileBattery.getEnergyForTier(ItemBlockBattery.getTier(itemStack)));
            battery.getEnergyHandler().setEnergy(itemBlock.getEnergy(itemStack));
            battery.updateStructure();
            world.func_72921_c(x, y, z, (int)ItemBlockBattery.getTier(itemStack), 3);
        }
    }

    public boolean onSneakUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            InventoryUtility.dropBlockAsItem((World)world, (int)x, (int)y, (int)z, (boolean)true);
        }
        return true;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack itemStack = new ItemStack((Block)this, 1);
        if (world.func_72796_p(x, y, z) instanceof TileBattery) {
            TileBattery battery = (TileBattery)world.func_72796_p(x, y, z);
            ItemBlockBattery itemBlock = (ItemBlockBattery)itemStack.func_77973_b();
            ItemBlockBattery.setTier(itemStack, (byte)world.func_72805_g(x, y, z));
            itemBlock.setEnergy(itemStack, battery.getEnergyHandler().getEnergy());
        }
        ret.add(itemStack);
        return ret;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return BlockRenderingHandler.INSTANCE.getRenderId();
    }

    public TileEntity func_72274_a(World world) {
        return new TileBattery();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int id = this.func_71922_a(world, x, y, z);
        if (id == 0) {
            return null;
        }
        Item item = Item.field_77698_e[id];
        if (item == null) {
            return null;
        }
        TileBattery battery = (TileBattery)world.func_72796_p(x, y, z);
        return CompatibilityModule.getItemWithCharge((ItemStack)ItemBlockBattery.setTier(new ItemStack(id, 1, 0), (byte)world.func_72805_g(x, y, z)), (long)battery.getEnergyHandler().getEnergy());
    }
}

