/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.battery;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.RenderUtility;
import resonantinduction.electrical.battery.ItemBlockBattery;
import resonantinduction.electrical.battery.TileBattery;
import universalelectricity.api.vector.Vector3;

@SideOnly(value=Side.CLIENT)
public class RenderBattery
extends TileEntitySpecialRenderer
implements ISimpleItemRenderer {
    public static RenderBattery INSTANCE = new RenderBattery();
    public static final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/battery/battery.tcn");

    public void renderInventoryItem(ItemStack itemStack) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
        int energyLevel = (int)((double)((ItemBlockBattery)itemStack.func_77973_b()).getEnergy(itemStack) / (double)((ItemBlockBattery)itemStack.func_77973_b()).getEnergyCapacity(itemStack) * 8.0);
        RenderUtility.bind((String)"resonantinduction", (String)"models/battery/battery.png");
        ArrayList<String> disabledParts = new ArrayList<String>();
        disabledParts.addAll(Arrays.asList("connector", "connectorIn", "connectorOut"));
        disabledParts.addAll(Arrays.asList("coil1", "coil2", "coil3", "coil4", "coil5", "coil6", "coil7", "coil8"));
        disabledParts.addAll(Arrays.asList("coil1lit", "coil2lit", "coil3lit", "coil4lit", "coil5lit", "coil6lit", "coil7lit", "coil8lit"));
        disabledParts.addAll(Arrays.asList("frame1con", "frame2con", "frame3con", "frame4con"));
        MODEL.renderAllExcept(disabledParts.toArray(new String[0]));
        for (int i = 1; i <= 8; ++i) {
            if (i == 1 && disabledParts.contains("coil1")) continue;
            if (8 - i <= energyLevel) {
                MODEL.renderOnly(new String[]{"coil" + i + "lit"});
                continue;
            }
            MODEL.renderOnly(new String[]{"coil" + i});
        }
        GL11.glPopMatrix();
    }

    public void func_76894_a(TileEntity t, double x, double y, double z, float f) {
        String[][] partToDisable = new String[][]{{"bottom"}, {"top"}, {"frame1", "frame2"}, {"frame3", "frame4"}, {"frame4", "frame1"}, {"frame2", "frame3"}};
        String[][] connectionPartToEnable = new String[][]{null, null, {"frame1con", "frame2con"}, {"frame3con", "frame4con"}, {"frame4con", "frame1con"}, {"frame2con", "frame3con"}};
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        TileBattery tile = (TileBattery)t;
        int energyLevel = (int)Math.round((double)tile.getEnergyHandler().getEnergy() / (double)TileBattery.getEnergyForTier(tile.func_70322_n()) * 8.0);
        RenderUtility.bind((String)"resonantinduction", (String)"models/battery/battery.png");
        ArrayList<String> disabledParts = new ArrayList<String>();
        ArrayList<String> enabledParts = new ArrayList<String>();
        for (ForgeDirection check : ForgeDirection.VALID_DIRECTIONS) {
            if (new Vector3(t).translate(check).getTileEntity((IBlockAccess)t.field_70331_k) instanceof TileBattery) {
                disabledParts.addAll(Arrays.asList(partToDisable[check.ordinal()]));
                if (check == ForgeDirection.UP) {
                    enabledParts.addAll(Arrays.asList(partToDisable[check.ordinal()]));
                    enabledParts.add("coil1");
                } else if (check == ForgeDirection.DOWN) {
                    ArrayList<String> connectionParts = new ArrayList<String>();
                    for (ForgeDirection sideCheck : ForgeDirection.VALID_DIRECTIONS) {
                        if (sideCheck.offsetY != 0) continue;
                        connectionParts.addAll(Arrays.asList(connectionPartToEnable[sideCheck.ordinal()]));
                    }
                    for (ForgeDirection sideCheck : ForgeDirection.VALID_DIRECTIONS) {
                        if (sideCheck.offsetY != 0 || !(new Vector3(t).translate(sideCheck).getTileEntity((IBlockAccess)t.field_70331_k) instanceof TileBattery)) continue;
                        connectionParts.removeAll(Arrays.asList(connectionPartToEnable[sideCheck.ordinal()]));
                    }
                    enabledParts.addAll(connectionParts);
                }
            }
            if (check.offsetY != 0) continue;
            GL11.glPushMatrix();
            RenderUtility.rotateBlockBasedOnDirection((ForgeDirection)check);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int io = tile.getIO(check);
            if (io == 1) {
                MODEL.renderOnly(new String[]{"connectorIn"});
            } else if (io == 2) {
                MODEL.renderOnly(new String[]{"connectorOut"});
            }
            GL11.glPopMatrix();
        }
        enabledParts.removeAll(disabledParts);
        for (int i = 1; i <= 8; ++i) {
            if (i == 1 && !enabledParts.contains("coil1")) continue;
            if (8 - i < energyLevel) {
                MODEL.renderOnly(new String[]{"coil" + i + "lit"});
                continue;
            }
            MODEL.renderOnly(new String[]{"coil" + i});
        }
        disabledParts.addAll(Arrays.asList("connector", "connectorIn", "connectorOut"));
        disabledParts.addAll(Arrays.asList("coil1", "coil2", "coil3", "coil4", "coil5", "coil6", "coil7", "coil8"));
        disabledParts.addAll(Arrays.asList("coil1lit", "coil2lit", "coil3lit", "coil4lit", "coil5lit", "coil6lit", "coil7lit", "coil8lit"));
        disabledParts.addAll(Arrays.asList("frame1con", "frame2con", "frame3con", "frame4con"));
        enabledParts.removeAll(Arrays.asList("coil1", "coil2", "coil3", "coil4", "coil5", "coil6", "coil7", "coil8"));
        MODEL.renderAllExcept(disabledParts.toArray(new String[0]));
        MODEL.renderOnly(enabledParts.toArray(new String[0]));
        GL11.glPopMatrix();
    }
}

