/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.battery;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.IPacketSender;
import resonantinduction.core.ResonantInduction;
import resonantinduction.electrical.battery.TileEnergyDistribution;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.electricity.IVoltageOutput;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.energy.IEnergyContainer;
import universalelectricity.api.energy.IEnergyInterface;

public class TileBattery
extends TileEnergyDistribution
implements IVoltageInput,
IVoltageOutput,
IPacketSender,
IPacketReceiver,
IEnergyInterface,
IEnergyContainer {
    public static final int MAX_TIER = 2;
    public static final long DEFAULT_WATTAGE = TileBattery.getEnergyForTier(0);

    public TileBattery() {
        this.setEnergyHandler(new EnergyStorageHandler(0L));
        this.getEnergyHandler().setCapacity(Long.MAX_VALUE);
        this.ioMap = 0;
        this.saveIOMap = true;
    }

    public static long getEnergyForTier(int tier) {
        return Math.round(Math.pow(5.0E8, (float)tier / 2.7f + 1.0f) / 5.0E8) * 500000000L;
    }

    @Override
    public void initiate() {
        super.initiate();
        this.getEnergyHandler().setCapacity(TileBattery.getEnergyForTier(this.func_70322_n()));
        this.getEnergyHandler().setMaxTransfer(this.getEnergyHandler().getEnergyCapacity());
    }

    @Override
    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            this.markDistributionUpdate |= this.produce() > 0L;
        }
        super.func_70316_g();
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, this.getPacketData(0).toArray());
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        this.getEnergyHandler().setEnergy(data.readLong());
        this.ioMap = data.readShort();
    }

    public ArrayList getPacketData(int type) {
        ArrayList<Number> data = new ArrayList<Number>();
        data.add(this.renderEnergyAmount);
        data.add(this.ioMap);
        return data;
    }

    public long getVoltageOutput(ForgeDirection side) {
        return UniversalElectricity.DEFAULT_VOLTAGE;
    }

    public long getVoltageInput(ForgeDirection direction) {
        return UniversalElectricity.DEFAULT_VOLTAGE;
    }

    public void onWrongVoltage(ForgeDirection direction, long voltage) {
    }

    public void setIO(ForgeDirection dir, int type) {
        super.setIO(dir, type);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public String toString() {
        return "[TileBattery]" + this.x() + "x " + this.y() + "y " + this.z() + "z ";
    }
}

