/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.battery;

import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.prefab.tile.TileElectrical;
import resonantinduction.electrical.battery.EnergyDistributionNetwork;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.INetwork;
import universalelectricity.api.vector.Vector3;

public class TileEnergyDistribution
extends TileElectrical
implements IConnector<EnergyDistributionNetwork> {
    public boolean markClientUpdate = false;
    public boolean markDistributionUpdate = false;
    public long renderEnergyAmount = 0L;
    private EnergyDistributionNetwork network;

    public TileEnergyDistribution() {
        super(null);
    }

    public TileEnergyDistribution(Material material) {
        super(material);
    }

    public void initiate() {
        super.initiate();
        this.updateStructure();
    }

    public void onAdded() {
        if (!this.world().field_72995_K) {
            this.updateStructure();
        }
    }

    public void onNeighborChanged() {
        if (!this.world().field_72995_K) {
            this.updateStructure();
        }
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.markDistributionUpdate && this.ticks % 5L == 0L) {
                this.getNetwork().redistribute(new TileEnergyDistribution[0]);
                this.markDistributionUpdate = false;
            }
            if (this.markClientUpdate && this.ticks % 5L == 0L) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public long getEnergy(ForgeDirection from) {
        return this.getNetwork().totalEnergy;
    }

    public long getEnergyCapacity(ForgeDirection from) {
        return this.getNetwork().totalCapacity;
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        long returnValue = super.onReceiveEnergy(from, receive, doReceive);
        this.markDistributionUpdate = true;
        this.markClientUpdate = true;
        return returnValue;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        long returnValue = super.onExtractEnergy(from, extract, doExtract);
        this.markDistributionUpdate = true;
        this.markClientUpdate = true;
        return returnValue;
    }

    public EnergyDistributionNetwork getNetwork() {
        if (this.network == null) {
            this.network = new EnergyDistributionNetwork();
            this.network.addConnector(this);
        }
        return this.network;
    }

    public void setNetwork(EnergyDistributionNetwork structure) {
        this.network = structure;
    }

    public void updateStructure() {
        if (!this.field_70331_k.field_72995_K) {
            for (Object obj : this.getConnections()) {
                if (obj == null) continue;
                this.getNetwork().merge((INetwork)((TileEnergyDistribution)((Object)obj)).getNetwork());
            }
            this.markDistributionUpdate = true;
            this.markClientUpdate = true;
        }
    }

    public Object[] getConnections() {
        Object[] connections = new Object[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = new Vector3((TileEntity)this).translate(dir).getTileEntity((IBlockAccess)this.field_70331_k);
            if (tile == null || tile.getClass() != ((Object)((Object)this)).getClass()) continue;
            connections[dir.ordinal()] = tile;
        }
        return connections;
    }

    public void func_70313_j() {
        this.getNetwork().redistribute(this);
        this.getNetwork().split(this);
        super.func_70313_j();
    }

    public IConnector<EnergyDistributionNetwork> getInstance(ForgeDirection from) {
        return this;
    }
}

