/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.encoder;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.tile.TileExternalInventory;
import resonantinduction.core.ResonantInduction;
import resonantinduction.electrical.armbot.Program;
import resonantinduction.electrical.armbot.task.TaskRotateTo;
import resonantinduction.electrical.encoder.IInventoryWatcher;
import resonantinduction.electrical.encoder.coding.IProgram;
import resonantinduction.electrical.encoder.coding.ITask;
import resonantinduction.electrical.encoder.coding.TaskRegistry;
import universalelectricity.api.vector.Vector2;

public class TileEncoder
extends TileExternalInventory
implements ISidedInventory,
IPacketReceiver {
    private ItemStack disk;
    private IInventoryWatcher watcher;
    public static final int PROGRAM_PACKET_ID = 0;
    public static final int PROGRAM_CHANGE_PACKET_ID = 1;
    public static final int REMOVE_TASK_PACKET_ID = 2;
    public static final int NEW_TASK_PACKET_ID = 3;
    protected IProgram program;

    public void initiate() {
        super.initiate();
        if (!this.field_70331_k.field_72995_K) {
            this.program = new Program();
            this.program.setTaskAt(0, 0, new TaskRotateTo());
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.watcher != null) {
            this.watcher.inventoryChanged();
        }
    }

    public String func_70303_b() {
        return "Encoder";
    }

    public int func_70297_j_() {
        return 1;
    }

    public void setWatcher(IInventoryWatcher watcher) {
        this.watcher = watcher;
    }

    public IInventoryWatcher getWatcher() {
        return this.watcher;
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.disk != null) {
            NBTTagCompound diskNBT = new NBTTagCompound();
            this.disk.func_77955_b(diskNBT);
            nbt.func_74766_a("disk", diskNBT);
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagCompound diskNBT = nbt.func_74775_l("disk");
        if (diskNBT != null) {
            this.disk = ItemStack.func_77949_a((NBTTagCompound)diskNBT);
        }
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            int readInt = data.readInt();
            if (readInt == 0) {
                if (data.readBoolean()) {
                    Program program = new Program();
                    program.load(PacketHandler.readNBTTagCompound((DataInput)data));
                    this.program = program;
                } else {
                    this.program = null;
                }
            } else if (readInt == 1) {
                ITask task = TaskRegistry.getCommand(data.readUTF());
                task.setPosition(data.readInt(), data.readInt());
                task.load(PacketHandler.readNBTTagCompound((DataInput)data));
                this.getProgram().setTaskAt(task.getCol(), task.getRow(), task);
                this.sendGUIPacket();
            } else if (readInt == 3) {
                ITask task = TaskRegistry.getCommand(data.readUTF());
                task.setPosition(data.readInt(), data.readInt());
                task.load(PacketHandler.readNBTTagCompound((DataInput)data));
                this.getProgram().insertTask(task.getCol(), task.getRow(), task);
                this.sendGUIPacket();
            } else if (readInt == 2) {
                this.getProgram().setTaskAt(data.readInt(), data.readInt(), null);
                this.sendGUIPacket();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendGUIPacket() {
    }

    public Packet func_70319_e() {
        boolean exists;
        NBTTagCompound tag = new NBTTagCompound();
        boolean bl = exists = this.program != null;
        if (exists) {
            this.program.save(tag);
        }
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{0, this, exists, tag});
    }

    public void removeTask(Vector2 vec) {
        if (vec != null) {
            if (this.field_70331_k.field_72995_K) {
                PacketDispatcher.sendPacketToServer((Packet)ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{2, this, vec.intX(), vec.intY()}));
            } else {
                this.program.setTaskAt(vec.intX(), vec.intY(), null);
            }
        }
    }

    public void updateTask(ITask editTask) {
        if (editTask != null) {
            if (this.field_70331_k.field_72995_K) {
                NBTTagCompound nbt = new NBTTagCompound();
                editTask.save(nbt);
                PacketDispatcher.sendPacketToServer((Packet)ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{1, this, editTask.getMethodName(), editTask.getCol(), editTask.getRow(), nbt}));
            } else {
                this.program.setTaskAt(editTask.getCol(), editTask.getRow(), editTask);
            }
        }
    }

    public void insertTask(ITask editTask) {
        if (editTask != null) {
            if (this.field_70331_k.field_72995_K) {
                NBTTagCompound nbt = new NBTTagCompound();
                editTask.save(nbt);
                PacketDispatcher.sendPacketToServer((Packet)ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{3, this, editTask.getMethodName(), editTask.getCol(), editTask.getRow(), nbt}));
            } else {
                this.program.insertTask(editTask.getCol(), editTask.getRow(), editTask);
            }
        }
    }

    public IProgram getProgram() {
        if (this.program == null) {
            this.program = new Program();
        }
        return this.program;
    }
}

