/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.encoder.coding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.IProgram;
import resonantinduction.electrical.encoder.coding.IProgrammableMachine;
import resonantinduction.electrical.encoder.coding.ITask;
import universalelectricity.api.vector.Vector3;

public class ProgramHelper {
    protected IProgram program;
    protected IProgrammableMachine bot;
    protected ITask currentTask;
    boolean hasMemory = false;
    boolean hasTaskBeenCalled = false;
    boolean nextTask = false;
    protected int memorySize = 0;
    protected HashMap<String, Object> taskMemory = new HashMap();

    public ProgramHelper(IProgrammableMachine bot) {
        this.bot = bot;
    }

    public IProcessTask.ProcessReturn onUpdate(World world, Vector3 botLocation) {
        IProcessTask.ProcessReturn re = IProcessTask.ProcessReturn.DONE;
        if (this.program != null) {
            if (this.currentTask == null || this.nextTask) {
                this.nextTask();
            }
            if (this.currentTask != null) {
                if (!this.hasTaskBeenCalled) {
                    this.hasTaskBeenCalled = true;
                    if (this.currentTask instanceof IProcessTask) {
                        re = ((IProcessTask)this.currentTask).onMethodCalled();
                        if (re == IProcessTask.ProcessReturn.DONE) {
                            this.nextTask = true;
                        } else if (re != IProcessTask.ProcessReturn.CONTINUE) {
                            return re;
                        }
                    }
                }
                if (this.currentTask instanceof IProcessTask) {
                    re = ((IProcessTask)this.currentTask).onUpdate();
                    if (re == IProcessTask.ProcessReturn.DONE) {
                        this.nextTask = true;
                    }
                } else {
                    re = IProcessTask.ProcessReturn.CONTINUE;
                }
                return re;
            }
        }
        return re;
    }

    public void nextTask() {
        this.hasTaskBeenCalled = false;
        this.nextTask = false;
        this.currentTask = this.program.getNextTask();
    }

    public ProgramHelper setMemoryLimit(int varableLimit) {
        if (varableLimit > 0) {
            this.memorySize = varableLimit;
            this.hasMemory = true;
        } else {
            this.taskMemory = null;
        }
        return this;
    }

    public ProgramHelper setProgram(IProgram program) {
        this.program = program;
        this.onProgramChanged();
        return this;
    }

    public IProgram getProgram() {
        return this.program;
    }

    public void onProgramChanged() {
        this.taskMemory.clear();
        if (this.program != null) {
            HashMap<String, Object> memory = this.program.getDeclairedVarables();
            if (memory.size() <= this.memorySize) {
                // empty if block
            }
            this.program.init(this.bot);
        }
    }

    public Object getMemoryLocation(String var) {
        return this.taskMemory.get(var);
    }

    public boolean setMemoryLocation(String var, Object object) {
        if (var != null) {
            if (this.taskMemory.containsKey(var)) {
                if (object == null) {
                    this.taskMemory.remove(var);
                }
                return this.addMemory(var, object);
            }
            if (object != null && this.taskMemory.size() < this.memorySize) {
                return this.addMemory(var, object);
            }
        }
        return false;
    }

    protected boolean addMemory(String var, Object object) {
        if (!(object instanceof Arrays && object instanceof ArrayList && object instanceof List && object instanceof Set)) {
            return this.taskMemory.put(var, object) != null;
        }
        return false;
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        return nbt;
    }

    public void load(NBTTagCompound nbt) {
    }
}

