/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.encoder.gui;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import resonant.api.IScroll;
import resonantinduction.electrical.armbot.task.TaskEnd;
import resonantinduction.electrical.armbot.task.TaskIdle;
import resonantinduction.electrical.armbot.task.TaskStart;
import resonantinduction.electrical.encoder.TileEncoder;
import resonantinduction.electrical.encoder.coding.IProgram;
import resonantinduction.electrical.encoder.coding.IRedirectTask;
import resonantinduction.electrical.encoder.coding.ITask;
import resonantinduction.electrical.encoder.gui.GuiEncoderCoder;
import resonantinduction.electrical.encoder.gui.GuiEncoderEditTask;

public class GuiEncoderTaskList
extends Gui
implements IScroll {
    protected int scrollY = 0;
    protected int scrollX;
    protected TileEntity entity;
    public String displayString;
    int xPos;
    int yPos;
    int countX = 6;
    int countY = 6;
    GuiEncoderCoder coder;

    public GuiEncoderTaskList(TileEntity entity, GuiEncoderCoder coder, int x, int y) {
        this.xPos = x;
        this.yPos = y;
        this.coder = coder;
        this.entity = entity;
        if (this.getProgram() != null) {
            this.scrollX = this.getProgram().getSize().intX() < this.countX / 2 ? -2 : 0;
        } else {
            this.scrollX = 0;
            this.scrollY = 0;
        }
    }

    public IProgram getProgram() {
        if (this.entity instanceof TileEncoder) {
            return ((TileEncoder)this.entity).getProgram();
        }
        return null;
    }

    public void scroll(int amount) {
        this.scrollY += amount;
    }

    public void scrollSide(int i) {
        this.scrollX += i;
    }

    public void setScroll(int length) {
        this.scrollY = length;
    }

    public int getScroll() {
        return this.scrollY;
    }

    public void drawConsole(Minecraft mc) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int colume = 0; colume < this.countX; ++colume) {
            int actualCol = colume + this.scrollX;
            for (int row = 0; row < this.countY; ++row) {
                int actualRow = row + this.scrollY - 1;
                boolean drawnButton = false;
                if (this.getProgram() != null) {
                    ITask task = this.getProgram().getTaskAt(actualCol, actualRow);
                    if (actualRow == -1 && colume + this.scrollX - 1 == -1) {
                        task = new TaskStart();
                    } else if (actualRow == this.getProgram().getSize().intY() + 1 && colume + this.scrollX - 1 == -1) {
                        task = new TaskEnd();
                    }
                    if (task != null && (!(task instanceof IRedirectTask) || task instanceof IRedirectTask && ((IRedirectTask)task).render())) {
                        drawnButton = true;
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(task.getTextureSheet());
                        this.func_73729_b(this.xPos + 20 * colume, this.yPos + 20 * row, task.getTextureUV().intX(), task.getTextureUV().intY(), 20, 20);
                    }
                }
                if (drawnButton) continue;
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(ITask.TaskType.TEXTURE);
                this.func_73729_b(this.xPos + 20 * colume, this.yPos + 20 * row, 0, 40, 20, 20);
            }
        }
    }

    protected void drawGuiContainerForegroundLayer(Minecraft mc, int cx, int cy) {
        ITask task = this.getTaskAt(cx, cy);
        if (task != null && this.coder != null) {
            this.coder.drawTooltip(cx - this.coder.getGuiLeft(), cy - this.coder.getGuiTop() + 10, new String[]{"[" + task.getRow() + "," + task.getCol() + "] " + task.getMethodName()});
        }
    }

    public void mousePressed(int cx, int cy) {
        ITask task = this.getTaskAt(cx, cy);
        if (task != null) {
            if (this.coder.insertingTask) {
                TaskIdle t = new TaskIdle();
                if (this.coder.bellow) {
                    if (task instanceof TaskEnd) {
                        this.coder.helpMessage = "Can't insert bellow end";
                        return;
                    }
                    t.setPosition(task.getCol(), task.getRow() + 1);
                } else {
                    if (task instanceof TaskStart) {
                        this.coder.helpMessage = "Can't insert above start";
                        return;
                    }
                    t.setPosition(task.getCol(), task.getRow());
                }
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiEncoderEditTask(this.coder, t, true));
            } else {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiEncoderEditTask(this.coder, task, false));
            }
        }
    }

    public ITask getTaskAt(int cx, int cz) {
        if (cx >= this.xPos && cz >= this.yPos && cx < this.xPos + this.countX * 20 + 20 && cz < this.yPos + this.countX * 20 + 20) {
            int col = (cx - this.xPos) / 20 + this.scrollX;
            int row = (cz - this.yPos) / 20 + this.scrollY;
            if (row == 0 && col == 0) {
                return new TaskStart();
            }
            if (row == this.getProgram().getSize().intY() + 2 && col == 0) {
                return new TaskEnd();
            }
            if (this.getProgram() != null) {
                return this.getProgram().getTaskAt(col, row - 1);
            }
        }
        return null;
    }
}

