/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.itemrailing;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.grid.INodeProvider;
import resonant.lib.grid.Node;
import resonantinduction.electrical.itemrailing.GridRailing;
import resonantinduction.electrical.itemrailing.interfaces.IItemRailingProvider;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class NodeRailing
extends Node<IItemRailingProvider, GridRailing, Object> {
    protected byte connectionMap = Byte.parseByte("111111", 2);

    public NodeRailing(IItemRailingProvider parent) {
        super((INodeProvider)parent);
    }

    public NodeRailing setConnection(byte connectionMap) {
        this.connectionMap = connectionMap;
        return this;
    }

    protected GridRailing newGrid() {
        return new GridRailing(this, NodeRailing.class);
    }

    public void update(float deltaTime) {
        super.update(deltaTime);
    }

    protected void doRecache() {
        this.connections.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            NodeRailing check;
            TileEntity tile = new Vector3(this.position()).translate(dir).getTileEntity((IBlockAccess)this.world());
            if (!(tile instanceof IItemRailingProvider) || (check = (NodeRailing)((IItemRailingProvider)tile).getNode(NodeRailing.class, dir.getOpposite())) == null || !this.canConnect(dir, (Object)check) || !check.canConnect(dir.getOpposite(), (Object)this)) continue;
            this.connections.put(check, dir);
        }
    }

    public IVector3 position() {
        return ((IItemRailingProvider)this.parent).getVectorWorld();
    }

    public World world() {
        return ((IItemRailingProvider)this.parent).getVectorWorld().world();
    }

    public boolean canConnect(ForgeDirection from, Object source) {
        return source instanceof NodeRailing && (this.connectionMap & 1 << from.ordinal()) != 0;
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
    }
}

