/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.itemrailing;

import codechicken.lib.vec.Vector3;
import codechicken.microblock.IHollowConnect;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.TSlottedPart;
import java.lang.reflect.Constructor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IExternalInventory;
import resonant.api.IExternalInventoryBox;
import resonant.api.grid.INode;
import resonant.lib.utility.inventory.ExternalInventory;
import resonantinduction.core.prefab.part.PartFramedNode;
import resonantinduction.electrical.Electrical;
import resonantinduction.electrical.itemrailing.EnumRailingMaterial;
import resonantinduction.electrical.itemrailing.NodeRailing;
import resonantinduction.electrical.itemrailing.interfaces.IItemRailingProvider;
import universalelectricity.api.vector.IVectorWorld;
import universalelectricity.api.vector.VectorWorld;

public class PartRailing
extends PartFramedNode<EnumRailingMaterial, NodeRailing, IItemRailingProvider>
implements IItemRailingProvider,
TSlottedPart,
JNormalOcclusion,
IHollowConnect,
IExternalInventory {
    protected ExternalInventory inventory;
    protected boolean markPacketUpdate;

    public PartRailing() {
        super(Electrical.itemInsulation);
        this.material = EnumRailingMaterial.DEFAULT;
        this.node = new NodeRailing(this);
        this.markPacketUpdate = true;
        this.requiresInsulation = false;
        this.inventory = new ExternalInventory((TileEntity)this.tile(), 5);
    }

    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if (nodeType.isInstance(this.node)) {
            return this.node;
        }
        try {
            for (Constructor<?> con : nodeType.getConstructors()) {
                if (con.getParameterTypes().length != 1 || !con.getParameterTypes()[0].equals(this.getClass())) continue;
                this.node = (NodeRailing)((Object)con.newInstance(this));
                return this.node;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public VectorWorld getWorldPos() {
        return new VectorWorld(this.getWorld(), (double)this.x(), (double)this.y(), (double)this.z());
    }

    public boolean doesTick() {
        return false;
    }

    public void setMaterial(int i) {
        this.material = EnumRailingMaterial.values()[i];
    }

    protected ItemStack getItem() {
        return new ItemStack(Electrical.itemRailing, 1, this.getMaterialID());
    }

    public String getType() {
        return "resonant_induction_itemrailing";
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        super.renderDynamic(pos, frame, pass);
    }

    @Override
    public IVectorWorld getVectorWorld() {
        return new VectorWorld(this.getWorld(), (double)this.x(), (double)this.y(), (double)this.z());
    }

    @Override
    public void onInventoryChanged() {
    }

    public IExternalInventoryBox getInventory() {
        return this.inventory;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return false;
    }

    public boolean canRemove(ItemStack stack, int slot, ForgeDirection side) {
        return false;
    }
}

