/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.laser.gun;

import java.awt.Color;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import resonant.api.event.LaserEvent;
import resonant.lib.prefab.vector.RayTraceHelper;
import resonant.lib.thermal.ThermalGrid;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.item.ItemElectric;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class ItemThermalLaser
extends ItemElectric {
    long batterySize = 100000L;
    float wattPerShot = 1.0f;
    float damageToEntities = 3.3f;
    int blockRange = 50;
    int firingDelay = 5;
    int breakTime = 15;
    boolean createLava = true;
    boolean setFire = true;

    public ItemThermalLaser(int id) {
        super(id);
        this.func_77655_b("MiningLaser");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 1000;
    }

    public void onUsingItemTick(ItemStack stack, EntityPlayer player, int count) {
        if (count > 5) {
            Vec3 playerPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
            Vec3 playerLook = RayTraceHelper.getLook((Entity)player, (float)1.0f);
            Vec3 p = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a), (double)(playerPosition.field_72448_b + playerLook.field_72448_b), (double)(playerPosition.field_72449_c + playerLook.field_72449_c));
            Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * (double)this.blockRange), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * (double)this.blockRange), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * (double)this.blockRange));
            MovingObjectPosition hit = RayTraceHelper.do_rayTraceFromEntity((Entity)player, (Vec3)new Vector3().toVec3(), (double)this.blockRange, (boolean)true);
            if (hit != null) {
                LaserEvent.LaserFiredPlayerEvent event = new LaserEvent.LaserFiredPlayerEvent(player, hit, stack);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!player.field_70170_p.field_72995_K && !event.isCanceled()) {
                    if (hit.field_72313_a == EnumMovingObjectType.ENTITY && hit.field_72308_g != null) {
                        DamageSource damageSource = DamageSource.func_76358_a((EntityLivingBase)player);
                        hit.field_72308_g.func_70097_a(damageSource, this.damageToEntities);
                        hit.field_72308_g.func_70015_d(5);
                    } else if (hit.field_72313_a == EnumMovingObjectType.TILE) {
                        ThermalGrid.addTemperature((VectorWorld)new VectorWorld(player.field_70170_p, (double)hit.field_72311_b, (double)hit.field_72312_c, (double)hit.field_72309_d), (float)100.0f);
                    }
                }
                playerViewOffset = hit.field_72307_f;
            }
            float x = (float)((double)MathHelper.func_76134_b((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.4 - (double)MathHelper.func_76126_a((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.1);
            float z = (float)((double)MathHelper.func_76126_a((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.4 + (double)MathHelper.func_76134_b((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.1);
            ResonantInduction.proxy.renderBeam(player.field_70170_p, (IVector3)new Vector3(p).translate((IVector3)new Vector3((double)x, -0.25, (double)z)), (IVector3)new Vector3(playerViewOffset), Color.ORANGE, 1);
            ResonantInduction.proxy.renderBeam(player.field_70170_p, (IVector3)new Vector3(p).translate((IVector3)new Vector3((double)x, -0.45, (double)z)), (IVector3)new Vector3(playerViewOffset), Color.ORANGE, 1);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World par2World, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || (float)this.getEnergy(itemStack) > this.wattPerShot) {
            player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        return itemStack;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public long getEnergyCapacity(ItemStack theItem) {
        return this.batterySize;
    }
}

