/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.levitator;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockVine;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;
import resonant.lib.render.EnumColor;
import resonant.lib.utility.LinkUtility;
import resonant.lib.utility.WrenchUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.MultipartUtility;
import resonantinduction.core.Settings;
import resonantinduction.core.prefab.part.PartFace;
import resonantinduction.electrical.Electrical;
import resonantinduction.electrical.levitator.PathfinderLevitator;
import resonantinduction.electrical.levitator.RenderLevitator;
import resonantinduction.electrical.levitator.ThreadLevitatorPathfinding;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class PartLevitator
extends PartFace {
    public boolean input = true;
    public float renderRotation = 0.0f;
    private int pushDelay;
    private AxisAlignedBB operationBounds;
    private AxisAlignedBB suckBounds;
    private ThreadLevitatorPathfinding thread;
    private PathfinderLevitator pathfinder;
    private WeakReference<PartLevitator> linked;
    private int lastCalcTime = 0;
    private int dyeID = 12;
    private byte saveLinkSide;
    private VectorWorld saveLinkVector;

    public static boolean canBePath(World world, Vector3 position) {
        Block block = Block.field_71973_m[position.getBlockID((IBlockAccess)world)];
        return block == null || block instanceof BlockSnow || block instanceof BlockVine || block instanceof BlockLadder || (block instanceof BlockFluid || block instanceof IFluidBlock) && block.field_71990_ca != Block.field_71944_C.field_71990_ca && block.field_71990_ca != Block.field_71938_D.field_71990_ca;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack itemStack) {
        if (WrenchUtility.isWrench((ItemStack)itemStack)) {
            if (this.tryLink(LinkUtility.getLink((ItemStack)itemStack), LinkUtility.getSide((ItemStack)itemStack))) {
                if (this.world().field_72995_K) {
                    player.func_71035_c("Successfully linked devices.");
                }
                LinkUtility.clearLink((ItemStack)itemStack);
            } else {
                if (this.world().field_72995_K) {
                    player.func_71035_c("Marked link for device.");
                }
                LinkUtility.setLink((ItemStack)itemStack, (VectorWorld)new VectorWorld(this.world(), (double)this.x(), (double)this.y(), (double)this.z()));
                LinkUtility.setSide((ItemStack)itemStack, (byte)((byte)this.placementSide.ordinal()));
            }
            return true;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().field_77993_c == Item.field_77756_aW.field_77779_bT) {
            this.setDye(player.func_71045_bC().func_77960_j());
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            return true;
        }
        if (player.func_70093_af()) {
            this.input = !this.input;
        }
        this.updateBounds();
        this.updatePath();
        return true;
    }

    public boolean tryLink(VectorWorld linkVector, byte side) {
        if (linkVector != null) {
            TMultiPart part = MultipartUtility.getMultipart((World)this.world(), (Vector3)linkVector, (int)side);
            if (part instanceof PartLevitator) {
                this.setLink((PartLevitator)part, true);
            }
            return true;
        }
        return false;
    }

    public PartLevitator getLink() {
        return this.linked != null && this.linked.get() != null && ((PartLevitator)((Object)this.linked.get())).world() != null ? (PartLevitator)((Object)this.linked.get()) : null;
    }

    public void onEntityCollision(Entity entity) {
        if (!this.world().field_72995_K && this.input && this.canFunction() && entity instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entity;
            IInventory inventory = (IInventory)this.getLatched();
            ItemStack remains = InventoryUtility.putStackInInventory((IInventory)inventory, (ItemStack)entityItem.func_92059_d(), (int)this.placementSide.getOpposite().getOpposite().ordinal(), (boolean)false);
            if (remains == null) {
                entityItem.func_70106_y();
            } else {
                entityItem.func_92059_d().field_77994_a = remains.field_77994_a;
            }
        }
    }

    public void update() {
        if (this.ticks % 60 == 0) {
            this.updateBounds();
        }
        super.update();
        this.pushDelay = Math.max(0, this.pushDelay - 1);
        if (this.saveLinkVector != null) {
            this.tryLink(this.saveLinkVector, this.saveLinkSide);
            this.saveLinkVector = null;
        }
        if (this.canFunction()) {
            boolean renderBeam;
            IInventory inventory = (IInventory)this.getLatched();
            if (!this.input) {
                ItemStack retrieved;
                this.renderRotation = Math.min(20.0f, this.renderRotation + 0.8f);
                if (this.pushDelay == 0 && (retrieved = InventoryUtility.takeTopItemFromInventory((IInventory)inventory, (int)this.placementSide.getOpposite().getOpposite().ordinal())) != null) {
                    EntityItem entityItem = this.getItemWithPosition(retrieved);
                    if (!this.world().field_72995_K) {
                        this.world().func_72838_d((Entity)entityItem);
                    }
                    this.pushDelay = Settings.LEVITATOR_PUSH_DELAY;
                }
            } else if (this.input) {
                this.renderRotation = Math.max(0.0f, this.renderRotation - 0.8f);
            }
            boolean renderPeriod = true;
            boolean bl = renderBeam = this.ticks % 1 == 0 && this.hasLink() && this.getLink().input != this.input;
            if (!this.input) {
                if (this.hasLink()) {
                    if (this.getLink().input) {
                        PathfinderLevitator newPath;
                        if (this.thread != null && (newPath = this.thread.getPath()) != null) {
                            this.pathfinder = newPath;
                            this.pathfinder.results.add(this.getPosition());
                            this.thread = null;
                        }
                        if (this.pathfinder != null) {
                            List results = this.pathfinder.results;
                            if (renderBeam) {
                                Electrical.proxy.renderElectricShock(this.world(), this.getBeamSpawnPosition(), this.getPosition().translate(0.5), EnumColor.DYES[this.dyeID].toColor(), (double)this.world().field_73012_v.nextFloat() > 0.9);
                                Electrical.proxy.renderElectricShock(this.world(), this.getLink().getPosition().translate(0.5), this.getLink().getBeamSpawnPosition(), EnumColor.DYES[this.dyeID].toColor(), (double)this.world().field_73012_v.nextFloat() > 0.9);
                            }
                            for (int i = 0; i < results.size(); ++i) {
                                Vector3 result = ((Vector3)results.get(i)).clone();
                                if (this.canBeMovePath(this.world(), result)) {
                                    if (i - 1 < 0) continue;
                                    Vector3 prevResult = ((Vector3)results.get(i - 1)).clone();
                                    Vector3 difference = prevResult.clone().difference((IVector3)result);
                                    ForgeDirection direction = difference.toForgeDirection();
                                    if (renderBeam) {
                                        Electrical.proxy.renderElectricShock(this.world(), prevResult.clone().translate(0.5), result.clone().translate(0.5), EnumColor.DYES[this.dyeID].toColor(), (double)this.world().field_73012_v.nextFloat() > 0.9);
                                    }
                                    AxisAlignedBB bounds = AxisAlignedBB.func_72332_a().func_72299_a(result.x, result.y, result.z, result.x + 1.0, result.y + 1.0, result.z + 1.0);
                                    List entities = this.world().func_72872_a(EntityItem.class, bounds);
                                    for (EntityItem entityItem : entities) {
                                        this.moveEntity(entityItem, direction, result);
                                    }
                                    continue;
                                }
                                this.updatePath();
                                break;
                            }
                        } else {
                            this.updatePath();
                        }
                    }
                } else if (this.operationBounds != null) {
                    for (EntityItem entityItem : this.world().func_72872_a(EntityItem.class, this.operationBounds)) {
                        this.moveEntity(entityItem, this.placementSide.getOpposite(), this.getPosition());
                    }
                    if (this.ticks % 1 == 0) {
                        Electrical.proxy.renderElectricShock(this.world(), this.getBeamSpawnPosition(), new Vector3(this.operationBounds.field_72336_d - 0.5 - (double)((float)this.placementSide.offsetX / 3.0f), this.operationBounds.field_72337_e - 0.5 - (double)((float)this.placementSide.offsetY / 3.0f), this.operationBounds.field_72334_f - 0.5 - (double)((float)this.placementSide.offsetZ / 3.0f)), EnumColor.DYES[this.dyeID].toColor(), (double)this.world().field_73012_v.nextFloat() > 0.9);
                    }
                }
            }
            --this.lastCalcTime;
        }
    }

    public boolean canBeMovePath(World world, Vector3 position) {
        TMultiPart partSelf = MultipartUtility.getMultipart((VectorWorld)new VectorWorld(world, (IVector3)position), (int)this.placementSide.ordinal());
        if (partSelf == this) {
            return true;
        }
        TMultiPart partLink = MultipartUtility.getMultipart((VectorWorld)new VectorWorld(world, (IVector3)position), (int)this.getLink().placementSide.ordinal());
        if (partLink == this.getLink()) {
            return true;
        }
        return PartLevitator.canBePath(world, position);
    }

    private boolean hasLink() {
        return this.getLink() != null && this.getLink().getLink() == this;
    }

    private void moveEntity(EntityItem entityItem, ForgeDirection direction, Vector3 lockVector) {
        switch (direction) {
            case DOWN: {
                entityItem.func_70107_b(lockVector.x + 0.5, entityItem.field_70163_u, lockVector.z + 0.5);
                entityItem.field_70159_w = 0.0;
                entityItem.field_70179_y = 0.0;
                if (!this.input) {
                    entityItem.field_70181_x = Math.max(-Settings.LEVITATOR_MAX_SPEED, entityItem.field_70181_x - Settings.LEVITATOR_ACCELERATION);
                    break;
                }
                entityItem.field_70181_x = Math.min(Settings.LEVITATOR_MAX_SPEED, entityItem.field_70181_x + 0.04 + Settings.LEVITATOR_ACCELERATION);
                break;
            }
            case UP: {
                entityItem.func_70107_b(lockVector.x + 0.5, entityItem.field_70163_u, lockVector.z + 0.5);
                entityItem.field_70159_w = 0.0;
                entityItem.field_70179_y = 0.0;
                if (!this.input) {
                    entityItem.field_70181_x = Math.min(Settings.LEVITATOR_MAX_SPEED, entityItem.field_70181_x + 0.04 + Settings.LEVITATOR_ACCELERATION);
                    break;
                }
                entityItem.field_70181_x = Math.max(-Settings.LEVITATOR_MAX_SPEED, entityItem.field_70181_x - Settings.LEVITATOR_ACCELERATION);
                break;
            }
            case NORTH: {
                entityItem.func_70107_b(lockVector.x + 0.5, lockVector.y + 0.5, entityItem.field_70161_v);
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = 0.0;
                if (!this.input) {
                    entityItem.field_70179_y = Math.max(-Settings.LEVITATOR_MAX_SPEED, entityItem.field_70179_y - Settings.LEVITATOR_ACCELERATION);
                    break;
                }
                entityItem.field_70179_y = Math.min(Settings.LEVITATOR_MAX_SPEED, entityItem.field_70179_y + Settings.LEVITATOR_ACCELERATION);
                break;
            }
            case SOUTH: {
                entityItem.func_70107_b(lockVector.x + 0.5, lockVector.y + 0.5, entityItem.field_70161_v);
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = 0.0;
                if (!this.input) {
                    entityItem.field_70179_y = Math.min(Settings.LEVITATOR_MAX_SPEED, entityItem.field_70179_y + Settings.LEVITATOR_ACCELERATION);
                    break;
                }
                entityItem.field_70179_y = Math.max(-Settings.LEVITATOR_MAX_SPEED, entityItem.field_70179_y - Settings.LEVITATOR_ACCELERATION);
                break;
            }
            case WEST: {
                entityItem.func_70107_b(entityItem.field_70165_t, lockVector.y + 0.5, lockVector.z + 0.5);
                entityItem.field_70181_x = 0.0;
                entityItem.field_70179_y = 0.0;
                if (!this.input) {
                    entityItem.field_70159_w = Math.max(-Settings.LEVITATOR_MAX_SPEED, entityItem.field_70159_w - Settings.LEVITATOR_ACCELERATION);
                    break;
                }
                entityItem.field_70159_w = Math.min(Settings.LEVITATOR_MAX_SPEED, entityItem.field_70159_w + Settings.LEVITATOR_ACCELERATION);
                break;
            }
            case EAST: {
                entityItem.func_70107_b(entityItem.field_70165_t, lockVector.y + 0.5, lockVector.z + 0.5);
                entityItem.field_70181_x = 0.0;
                entityItem.field_70179_y = 0.0;
                if (!this.input) {
                    entityItem.field_70159_w = Math.min(Settings.LEVITATOR_MAX_SPEED, entityItem.field_70159_w + Settings.LEVITATOR_ACCELERATION);
                    break;
                }
                entityItem.field_70159_w = Math.max(-Settings.LEVITATOR_MAX_SPEED, entityItem.field_70159_w - Settings.LEVITATOR_ACCELERATION);
                break;
            }
        }
        entityItem.field_70173_aa = 1;
        entityItem.field_70160_al = true;
        entityItem.field_70293_c = 1;
        entityItem.field_70292_b = Math.max(entityItem.field_70292_b - 1, 0);
    }

    private EntityItem getItemWithPosition(ItemStack toSend) {
        EntityItem item = new EntityItem(this.world(), (double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, toSend);
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0;
        item.field_70179_y = 0.0;
        return item;
    }

    public void updateBounds() {
        this.operationBounds = null;
        this.suckBounds = null;
        ForgeDirection dir = this.placementSide.getOpposite();
        MovingObjectPosition mop = this.world().func_72933_a(this.getPosition().translate(dir).toVec3(), this.getPosition().translate(dir, (double)Settings.LEVITATOR_MAX_REACH).toVec3());
        int reach = Settings.LEVITATOR_MAX_REACH;
        if (mop != null && MultipartUtility.getMultipart((World)this.world(), (int)mop.field_72311_b, (int)mop.field_72312_c, (int)mop.field_72309_d, (int)this.placementSide.getOpposite().ordinal()) instanceof PartLevitator) {
            reach = (int)Math.min(this.getPosition().distance((IVector3)new Vector3(mop.field_72307_f)), (double)reach);
            if (dir.offsetX + dir.offsetY + dir.offsetZ < 0) {
                this.operationBounds = AxisAlignedBB.func_72330_a((double)(this.x() + dir.offsetX * reach), (double)(this.y() + dir.offsetY * reach), (double)(this.z() + dir.offsetZ * reach), (double)(this.x() + 1), (double)(this.y() + 1), (double)(this.z() + 1));
                this.suckBounds = AxisAlignedBB.func_72330_a((double)(this.x() + dir.offsetX), (double)(this.y() + dir.offsetY), (double)(this.z() + dir.offsetZ), (double)(this.x() + 1), (double)(this.y() + 1), (double)(this.z() + 1));
            } else {
                this.operationBounds = AxisAlignedBB.func_72330_a((double)this.x(), (double)this.y(), (double)this.z(), (double)(this.x() + 1 + dir.offsetX * reach), (double)(this.y() + 1 + dir.offsetY * reach), (double)(this.z() + 1 + dir.offsetZ * reach));
                this.suckBounds = AxisAlignedBB.func_72330_a((double)this.x(), (double)this.y(), (double)this.z(), (double)(this.x() + 1 + dir.offsetX), (double)(this.y() + 1 + dir.offsetY), (double)(this.z() + 1 + dir.offsetZ));
            }
        }
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.updateBounds();
    }

    public boolean canFunction() {
        return false;
    }

    public boolean isLatched() {
        return this.getLatched() != null;
    }

    public TileEntity getLatched() {
        ForgeDirection side = this.placementSide;
        TileEntity tile = this.world().func_72796_p(this.x() + side.offsetX, this.y() + side.offsetY, this.z() + side.offsetZ);
        if (tile instanceof IInventory) {
            return tile;
        }
        return null;
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.input = packet.readBoolean();
        this.dyeID = packet.readByte();
        if (packet.readBoolean()) {
            this.saveLinkVector = new VectorWorld(packet.readNBTTagCompound());
            this.saveLinkSide = packet.readByte();
        }
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeBoolean(this.input);
        packet.writeByte(this.dyeID);
        if (this.getLink() != null) {
            packet.writeBoolean(true);
            NBTTagCompound nbt = new NBTTagCompound();
            new VectorWorld(this.getLink().world(), (double)this.getLink().x(), (double)this.getLink().y(), (double)this.getLink().z()).writeToNBT(nbt);
            packet.writeNBTTagCompound(nbt);
            packet.writeByte(this.getLink().placementSide.ordinal());
        } else {
            packet.writeBoolean(false);
        }
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.input = nbt.func_74767_n("suck");
        this.dyeID = nbt.func_74762_e("dyeID");
        if (nbt.func_74764_b("link")) {
            this.saveLinkVector = new VectorWorld(nbt.func_74775_l("link"));
            this.saveLinkSide = nbt.func_74771_c("linkSide");
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74757_a("suck", this.input);
        nbt.func_74768_a("dyeID", this.dyeID);
        if (this.getLink() != null && this.getLink().world() != null) {
            nbt.func_74766_a("link", new VectorWorld(this.getLink().world(), (double)this.getLink().x(), (double)this.getLink().y(), (double)this.getLink().z()).writeToNBT(new NBTTagCompound()));
            nbt.func_74774_a("linkSide", (byte)this.getLink().placementSide.ordinal());
        }
    }

    public void setLink(PartLevitator levitator, boolean setOpponent) {
        if (this.getLink() != null && setOpponent) {
            this.getLink().setLink(null, false);
        }
        this.linked = new WeakReference<PartLevitator>(levitator);
        if (setOpponent) {
            this.getLink().setLink(this, false);
        }
        this.updatePath();
    }

    public void updatePath() {
        if (this.thread == null && this.getLink() != null && this.lastCalcTime <= 0) {
            Vector3 target;
            this.pathfinder = null;
            Vector3 start = this.getPosition();
            if (start.distance((IVector3)(target = new Vector3((double)this.getLink().x(), (double)this.getLink().y(), (double)this.getLink().z()))) < (double)Settings.MAX_LEVITATOR_DISTANCE && this.canBeMovePath(this.world(), start) && this.canBeMovePath(this.world(), target)) {
                this.thread = new ThreadLevitatorPathfinding(new PathfinderLevitator(this.world(), target), start);
                this.thread.start();
                this.lastCalcTime = 40;
            }
        }
    }

    public void setDye(int dye) {
        this.dyeID = dye;
        this.world().func_72845_h(this.x(), this.y(), this.z());
    }

    public Vector3 getPosition() {
        return new Vector3((double)this.x(), (double)this.y(), (double)this.z());
    }

    public Vector3 getBeamSpawnPosition() {
        return new Vector3((double)this.x() + 0.5 + (double)((float)this.placementSide.offsetX / 3.0f), (double)this.y() + 0.5 + (double)((float)this.placementSide.offsetY / 3.0f), (double)this.z() + 0.5 + (double)((float)this.placementSide.offsetZ / 3.0f));
    }

    protected ItemStack getItem() {
        return new ItemStack(Electrical.itemLevitator);
    }

    public String getType() {
        return "resonant_induction_levitator";
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(codechicken.lib.vec.Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderLevitator.INSTANCE.render(this, pos.x, pos.y, pos.z);
        }
    }
}

