/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.multimeter;

import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import resonantinduction.electrical.multimeter.Graph;

public class GraphD
extends Graph<Double> {
    public GraphD(String name, int maxPoints) {
        super(name, maxPoints);
    }

    @Override
    public void queue(Double value) {
        this.queue = Double.valueOf((Double)this.queue + value);
    }

    @Override
    public void doneQueue() {
        super.doneQueue();
        this.queue = Double.valueOf(0.0);
    }

    @Override
    public Double getDefault() {
        return 0.0;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        NBTTagList nbtList = nbt.func_74761_m("DataPoints");
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbtPoint = (NBTTagCompound)nbtList.func_74743_b(i);
            this.points.add((Object)nbtPoint.func_74769_h("data"));
        }
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList data = new NBTTagList();
        for (Double value : this.points) {
            NBTTagCompound nbtPoint = new NBTTagCompound();
            nbtPoint.func_74780_a("data", value.doubleValue());
            data.func_74742_a((NBTBase)nbtPoint);
        }
        nbt.func_74782_a("DataPoints", (NBTBase)data);
        return nbt;
    }

    @Override
    public double getDouble() {
        return (Double)this.get();
    }

    @Override
    public Double getAverage() {
        if (this.points.size() > 0) {
            double average = 0.0;
            Iterator i$ = this.points.iterator();
            while (i$.hasNext()) {
                double point = (Double)i$.next();
                average += point;
            }
            return average /= (double)this.points.size();
        }
        return 0.0;
    }
}

