/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.multimeter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.IMechanicalNode;
import resonant.api.grid.INodeProvider;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.utility.WrenchUtility;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.grid.fluid.FluidPressureNode;
import resonantinduction.core.grid.fluid.IPressureNodeProvider;
import resonantinduction.core.prefab.part.PartFace;
import resonantinduction.electrical.Electrical;
import resonantinduction.electrical.multimeter.MultimeterNetwork;
import resonantinduction.electrical.multimeter.RenderMultimeter;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.electricity.IElectricalNetwork;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyNetwork;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.INetwork;
import universalelectricity.api.vector.Vector3;

public class PartMultimeter
extends PartFace
implements IConnector<MultimeterNetwork>,
IRedstonePart,
IPacketReceiver {
    public Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public double redstoneTriggerLimit;
    public byte detectType = 0;
    public byte graphType = 0;
    private DetectMode detectMode = DetectMode.NONE;
    public boolean redstoneOn;
    private boolean doDetect = true;
    public boolean isPrimary;
    private MultimeterNetwork network;

    public boolean hasMultimeter(int x, int y, int z) {
        return this.getMultimeter(x, y, z) != null;
    }

    public void preRemove() {
        if (!this.world().field_72995_K) {
            this.getNetwork().split(this);
        }
    }

    public void refresh() {
        if (this.world() != null && !this.world().field_72995_K) {
            for (Object obj : this.getConnections()) {
                if (!(obj instanceof PartMultimeter)) continue;
                this.getNetwork().merge((INetwork)((PartMultimeter)((Object)obj)).getNetwork());
            }
            this.getNetwork().reconstruct();
        }
    }

    public void updateDesc() {
        this.writeDesc(this.getWriteStream());
    }

    public void updateGraph() {
        this.writeGraph(this.getWriteStream());
    }

    public void onWorldJoin() {
        this.refresh();
    }

    public void onNeighborChanged() {
        this.refresh();
    }

    public void onPartChanged(TMultiPart part) {
        this.refresh();
    }

    public PartMultimeter getMultimeter(int x, int y, int z) {
        TMultiPart part;
        TileEntity tileEntity = this.world().func_72796_p(x, y, z);
        if (tileEntity instanceof TileMultipart && (part = ((TileMultipart)tileEntity).partMap(this.placementSide.ordinal())) instanceof PartMultimeter) {
            return (PartMultimeter)part;
        }
        return null;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (WrenchUtility.isUsableWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)this.x(), (int)this.y(), (int)this.z())) {
            if (!this.world().field_72995_K) {
                this.doDetect = !this.doDetect;
                player.func_71035_c("Multimeter detection set to: " + this.doDetect);
                WrenchUtility.damageWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)this.x(), (int)this.y(), (int)this.z());
            }
            return true;
        }
        player.openGui((Object)Electrical.INSTANCE, this.placementSide.ordinal(), this.world(), this.x(), this.y(), this.z());
        return true;
    }

    public void update() {
        super.update();
        ++this.ticks;
        if (!this.world().field_72995_K) {
            if (this.doDetect) {
                this.updateDetections();
            }
            double detectedValue = this.getNetwork().graphs.get(this.detectType).getDouble();
            boolean outputRedstone = false;
            switch (this.detectMode) {
                default: {
                    break;
                }
                case EQUAL: {
                    outputRedstone = detectedValue == this.redstoneTriggerLimit;
                    break;
                }
                case GREATER_THAN: {
                    outputRedstone = detectedValue > this.redstoneTriggerLimit;
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    outputRedstone = detectedValue >= this.redstoneTriggerLimit;
                    break;
                }
                case LESS_THAN: {
                    outputRedstone = detectedValue < this.redstoneTriggerLimit;
                    break;
                }
                case LESS_THAN_EQUAL: {
                    outputRedstone = detectedValue <= this.redstoneTriggerLimit;
                }
            }
            this.getNetwork().markUpdate();
            if (this.ticks % 20 == 0) {
                if (outputRedstone != this.redstoneOn) {
                    this.redstoneOn = outputRedstone;
                    this.tile().notifyPartChange((TMultiPart)this);
                }
                this.updateGraph();
            }
        }
        if (!this.world().field_72995_K) {
            for (EntityPlayer player : this.playersUsing) {
                this.updateGraph();
            }
        }
    }

    public void updateDetections() {
        FluidTankInfo[] fluidInfo;
        IConnector instance;
        ForgeDirection receivingSide = this.getDirection().getOpposite();
        TileEntity tileEntity = this.getDetectedTile();
        if (tileEntity instanceof IConductor) {
            instance = ((IConductor)tileEntity).getInstance(receivingSide);
            for (ForgeDirection forgeDirection : ForgeDirection.values()) {
                if (instance != null) break;
                instance = ((IConnector)tileEntity).getInstance(forgeDirection);
            }
            if (instance != null && instance.getNetwork() instanceof IEnergyNetwork) {
                IEnergyNetwork network = (IEnergyNetwork)instance.getNetwork();
                this.getNetwork().energyGraph.queue(Math.max(network.getBuffer(), network.getLastBuffer()));
                this.getNetwork().powerGraph.queue(this.getNetwork().energyGraph.getAverage() * 20L);
                if (instance.getNetwork() instanceof IElectricalNetwork) {
                    this.getNetwork().voltageGraph.queue(((IElectricalNetwork)network).getVoltage());
                }
            }
        }
        if (tileEntity instanceof INodeProvider) {
            instance = (IMechanicalNode)((INodeProvider)tileEntity).getNode(IMechanicalNode.class, receivingSide);
            for (ForgeDirection forgeDirection : ForgeDirection.values()) {
                if (instance != null) break;
                instance = (IMechanicalNode)((INodeProvider)tileEntity).getNode(IMechanicalNode.class, forgeDirection);
            }
            if (instance != null) {
                this.getNetwork().torqueGraph.queue(instance.getTorque());
                this.getNetwork().angularVelocityGraph.queue(instance.getAngularVelocity());
                this.getNetwork().powerGraph.queue((long)instance.getPower());
            }
        }
        if (tileEntity instanceof IFluidHandler && (fluidInfo = ((IFluidHandler)tileEntity).getTankInfo(receivingSide)) != null) {
            for (ForgeDirection forgeDirection : fluidInfo) {
                if (forgeDirection == null || forgeDirection.fluid == null) continue;
                this.getNetwork().fluidGraph.queue(forgeDirection.fluid.amount);
            }
        }
        if (tileEntity instanceof IPressureNodeProvider) {
            this.getNetwork().pressureGraph.queue(((FluidPressureNode)((IPressureNodeProvider)tileEntity).getNode(FluidPressureNode.class, receivingSide)).getPressure(receivingSide));
        }
        this.getNetwork().energyGraph.queue(CompatibilityModule.getEnergy((Object)tileEntity, (ForgeDirection)receivingSide));
        this.getNetwork().energyCapacityGraph.queue(CompatibilityModule.getMaxEnergy((Object)tileEntity, (ForgeDirection)receivingSide));
    }

    public void readDesc(MCDataInput packet) {
        packet.readByte();
        this.placementSide = ForgeDirection.getOrientation((int)packet.readByte());
        this.facing = packet.readByte();
        this.detectMode = DetectMode.values()[packet.readByte()];
        this.detectType = packet.readByte();
        this.graphType = packet.readByte();
        this.getNetwork().center = new Vector3(packet.readNBTTagCompound());
        this.getNetwork().size = new Vector3(packet.readNBTTagCompound());
        this.getNetwork().isEnabled = packet.readBoolean();
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(0);
        packet.writeByte(this.placementSide.ordinal());
        packet.writeByte((int)this.facing);
        packet.writeByte(this.detectMode.ordinal());
        packet.writeByte((int)this.detectType);
        packet.writeByte((int)this.graphType);
        packet.writeNBTTagCompound(this.getNetwork().center.writeToNBT(new NBTTagCompound()));
        packet.writeNBTTagCompound(this.getNetwork().size.writeToNBT(new NBTTagCompound()));
        packet.writeBoolean(this.getNetwork().isEnabled);
    }

    public void writeGraph(MCDataOutput packet) {
        packet.writeByte(2);
        this.isPrimary = this.getNetwork().isPrimary(this);
        packet.writeBoolean(this.isPrimary);
        if (this.isPrimary) {
            packet.writeNBTTagCompound(this.getNetwork().save());
        }
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    public void read(MCDataInput packet, int packetID) {
        switch (packetID) {
            case 0: {
                this.placementSide = ForgeDirection.getOrientation((int)packet.readByte());
                this.facing = packet.readByte();
                this.detectMode = DetectMode.values()[packet.readByte()];
                this.detectType = packet.readByte();
                this.graphType = packet.readByte();
                this.getNetwork().center = new Vector3(packet.readNBTTagCompound());
                this.getNetwork().size = new Vector3(packet.readNBTTagCompound());
                this.getNetwork().isEnabled = packet.readBoolean();
                this.refresh();
                break;
            }
            case 1: {
                this.redstoneTriggerLimit = packet.readLong();
                break;
            }
            case 2: {
                this.isPrimary = packet.readBoolean();
                if (!this.isPrimary) break;
                this.getNetwork().load(packet.readNBTTagCompound());
            }
        }
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        this.detectMode = DetectMode.values()[data.readByte()];
        this.detectType = data.readByte();
        this.graphType = data.readByte();
        this.redstoneTriggerLimit = data.readDouble();
    }

    public TileEntity getDetectedTile() {
        ForgeDirection direction = this.getDirection();
        return this.world().func_72796_p(this.x() + direction.offsetX, this.y() + direction.offsetY, this.z() + direction.offsetZ);
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.placementSide.ordinal());
    }

    public void toggleGraphType() {
        this.graphType = (byte)((this.graphType + 1) % this.getNetwork().graphs.size());
        this.updateServer();
    }

    public void toggleMode() {
        this.detectMode = DetectMode.values()[(this.detectMode.ordinal() + 1) % DetectMode.values().length];
        this.updateServer();
    }

    public void toggleDetectionValue() {
        this.detectType = (byte)((this.detectType + 1) % this.getNetwork().graphs.size());
        this.updateServer();
    }

    public void updateServer() {
        PacketDispatcher.sendPacketToServer((Packet)ResonantInduction.PACKET_MULTIPART.getPacket(new Vector3((double)this.x(), (double)this.y(), (double)this.z()), this.placementSide.ordinal(), new Object[]{(byte)this.detectMode.ordinal(), this.detectType, this.graphType, this.redstoneTriggerLimit}));
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.placementSide = ForgeDirection.getOrientation((int)nbt.func_74771_c("side"));
        this.detectMode = DetectMode.values()[nbt.func_74771_c("detectMode")];
        this.detectType = nbt.func_74771_c("detectionType");
        this.graphType = nbt.func_74771_c("graphType");
        this.doDetect = nbt.func_74767_n("doDetect");
        this.redstoneTriggerLimit = nbt.func_74769_h("triggerLimit");
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74774_a("side", (byte)this.placementSide.ordinal());
        nbt.func_74774_a("detectMode", (byte)this.detectMode.ordinal());
        nbt.func_74774_a("detectionType", this.detectType);
        nbt.func_74774_a("graphType", this.graphType);
        nbt.func_74757_a("doDetect", this.doDetect);
        nbt.func_74780_a("triggerLimit", this.redstoneTriggerLimit);
    }

    public DetectMode getMode() {
        return this.detectMode;
    }

    public String getType() {
        return "resonant_induction_multimeter";
    }

    public int redstoneConductionMap() {
        return 31;
    }

    public boolean solid(int arg0) {
        return true;
    }

    protected ItemStack getItem() {
        return new ItemStack(Electrical.itemMultimeter);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(codechicken.lib.vec.Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderMultimeter.render(this, pos.x, pos.y, pos.z);
        }
    }

    public boolean canConnectRedstone(int arg0) {
        return true;
    }

    public int strongPowerLevel(int arg0) {
        return this.redstoneOn ? 14 : 0;
    }

    public int weakPowerLevel(int arg0) {
        return this.redstoneOn ? 14 : 0;
    }

    public MultimeterNetwork getNetwork() {
        if (this.network == null) {
            this.network = new MultimeterNetwork();
            this.network.addConnector(this);
        }
        return this.network;
    }

    public void setNetwork(MultimeterNetwork network) {
        this.network = network;
    }

    public boolean canConnect(ForgeDirection direction, Object obj) {
        return obj instanceof PartMultimeter;
    }

    public Object[] getConnections() {
        Object[] connections = new Object[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Vector3 vector;
            if (dir == this.getDirection() || dir == this.getDirection().getOpposite() || !this.hasMultimeter((vector = this.getPosition().translate(dir)).intX(), vector.intY(), vector.intZ())) continue;
            connections[dir.ordinal()] = this.getMultimeter(vector.intX(), vector.intY(), vector.intZ());
        }
        return connections;
    }

    public IConnector<MultimeterNetwork> getInstance(ForgeDirection dir) {
        return this;
    }

    public Vector3 getPosition() {
        return new Vector3((double)this.x(), (double)this.y(), (double)this.z());
    }

    @SideOnly(value=Side.CLIENT)
    public Cuboid6 getRenderBounds() {
        if (this.isPrimary) {
            return Cuboid6.full.copy().expand(new codechicken.lib.vec.Vector3(this.getNetwork().size.x, this.getNetwork().size.y, this.getNetwork().size.z));
        }
        return Cuboid6.full;
    }

    public String toString() {
        return "[PartMultimeter]" + this.x() + "x " + this.y() + "y " + this.z() + "z " + this.getSlotMask() + "s ";
    }

    public static enum DetectMode {
        NONE("none"),
        LESS_THAN("lessThan"),
        LESS_THAN_EQUAL("lessThanOrEqual"),
        EQUAL("equal"),
        GREATER_THAN_EQUAL("greaterThanOrEqual"),
        GREATER_THAN("greaterThan");

        public String display;

        private DetectMode(String s) {
            this.display = s;
        }
    }
}

