/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.multimeter;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.RenderUtility;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.core.ResonantInduction;
import resonantinduction.electrical.multimeter.PartMultimeter;
import universalelectricity.api.vector.Vector3;

@SideOnly(value=Side.CLIENT)
public class RenderMultimeter
implements ISimpleItemRenderer {
    public static final RenderMultimeter INSTANCE = new RenderMultimeter();
    private final ResourceLocation TEXTURE = new ResourceLocation("resonantinduction", "models/multimeter.png");

    public void renderInventoryItem(ItemStack itemStack) {
        RenderMultimeter.render();
    }

    public static void render() {
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderUtility.bind((ResourceLocation)TextureMap.field_110575_b);
        RenderUtility.renderCube((double)-0.5, (double)-0.05, (double)-0.5, (double)0.5, (double)0.05, (double)0.5, (Block)ResonantInduction.blockIndustrialStone, (Icon)((Icon)RenderUtility.loadedIconMap.get("resonantinduction:multimeter_screen")));
        ForgeDirection dir = ForgeDirection.NORTH;
        int metadata = 8;
        RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)-0.44, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
        RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)0.44, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection check = ForgeDirection.getOrientation((int)i);
            if (dir.offsetX != 0 && check.offsetZ != 0) {
                if (dir.offsetX != check.offsetZ) {
                    RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)-0.44, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                } else if (dir.offsetX == check.offsetZ) {
                    RenderUtility.renderCube((double)0.44, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                }
            }
            if (dir.offsetZ == 0 || check.offsetX == 0) continue;
            if (dir.offsetZ == check.offsetX) {
                RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)-0.44, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                continue;
            }
            if (dir.offsetZ == check.offsetX) continue;
            RenderUtility.renderCube((double)0.44, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
        }
        GL11.glPopMatrix();
    }

    public static void render(PartMultimeter part, double x, double y, double z) {
        ForgeDirection dir = part.getDirection();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderUtility.rotateFaceBlockToSideOutwards((ForgeDirection)part.getDirection().getOpposite());
        RenderUtility.bind((ResourceLocation)TextureMap.field_110575_b);
        RenderUtility.renderCube((double)-0.5, (double)-0.05, (double)-0.5, (double)0.5, (double)0.05, (double)0.5, (Block)ResonantInduction.blockIndustrialStone, (Icon)((Icon)RenderUtility.loadedIconMap.get("resonantinduction:multimeter_screen")));
        int metadata = 8;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection check = ForgeDirection.getOrientation((int)i);
            if (part.hasMultimeter(part.x() + check.offsetX, part.y() + check.offsetY, part.z() + check.offsetZ)) continue;
            if (dir.offsetX != 0) {
                if (check.offsetZ != 0) {
                    if (dir.offsetX != check.offsetZ) {
                        RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)-0.44, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    } else if (dir.offsetX == check.offsetZ) {
                        RenderUtility.renderCube((double)0.44, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    }
                } else if (check.offsetY != 0) {
                    if (check.offsetY > 0) {
                        RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)-0.44, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    } else {
                        RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)0.44, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    }
                }
            }
            if (dir.offsetZ != 0) {
                if (check.offsetX != 0) {
                    if (dir.offsetZ == check.offsetX) {
                        RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)-0.44, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    } else if (dir.offsetZ != check.offsetX) {
                        RenderUtility.renderCube((double)0.44, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    }
                } else if (check.offsetY != 0) {
                    if (check.offsetY > 0) {
                        RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)-0.44, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    } else {
                        RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)0.44, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    }
                }
            }
            if (dir.offsetY == 0) continue;
            if (check.offsetX != 0) {
                if (dir.offsetY != check.offsetX) {
                    RenderUtility.renderCube((double)0.44, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                    continue;
                }
                if (dir.offsetY != check.offsetX) continue;
                RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)-0.44, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                continue;
            }
            if (check.offsetZ == 0) continue;
            if (dir.offsetY != check.offsetZ) {
                RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)0.44, (double)0.501, (double)0.0501, (double)0.501, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
                continue;
            }
            if (dir.offsetY != check.offsetZ) continue;
            RenderUtility.renderCube((double)-0.501, (double)-0.0501, (double)-0.501, (double)0.501, (double)0.0501, (double)-0.44, (Block)ResonantInduction.blockIndustrialStone, null, (int)8);
        }
        GL11.glPopMatrix();
        if (part.getNetwork().isEnabled && part.isPrimary) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            Vector3 centerTranslation = part.getNetwork().center.clone().subtract((double)part.x(), (double)part.y(), (double)part.z()).add(-0.5);
            GL11.glTranslated((double)centerTranslation.x, (double)centerTranslation.y, (double)centerTranslation.z);
            RenderUtility.rotateFaceBlockToSideOutwards((ForgeDirection)part.getDirection().getOpposite());
            if (part.getDirection().offsetY != 0) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                RenderUtility.rotateBlockBasedOnDirection((ForgeDirection)part.getFacing());
            }
            GL11.glTranslated((double)0.0, (double)0.05, (double)0.0);
            ArrayList<String> information = new ArrayList<String>();
            for (int i = 0; i < part.getNetwork().graphs.size(); ++i) {
                if (part.getNetwork().graphs.get(i).get() == null || part.getNetwork().graphs.get(i).get().equals(part.getNetwork().graphs.get(i).getDefault())) continue;
                information.add(part.getNetwork().getDisplay(i));
            }
            if (information.size() <= 0) {
                information.add(LanguageUtility.getLocal((String)"tooltip.noInformation"));
            }
            float displacement = 0.72f / (float)information.size();
            float maxScale = (float)(part.getNetwork().size.x + part.getNetwork().size.z) * 0.004f;
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-displacement * ((float)information.size() / 2.0f)));
            for (int i = 0; i < information.size(); ++i) {
                String info = (String)information.get(i);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(displacement * (float)i));
                if (dir.offsetX != 0) {
                    RenderUtility.renderText((String)info, (float)((float)(part.getNetwork().size.z * (double)0.9f)), (float)maxScale);
                } else if (dir.offsetY != 0) {
                    RenderUtility.renderText((String)info, (float)((float)(Math.min(part.getNetwork().size.x, part.getNetwork().size.z) * (double)0.9f)), (float)maxScale);
                } else if (dir.offsetZ != 0) {
                    RenderUtility.renderText((String)info, (float)((float)(part.getNetwork().size.x * (double)0.9f)), (float)maxScale);
                }
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }
}

