/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.transformer;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.utility.WrenchUtility;
import resonantinduction.core.prefab.part.PartFace;
import resonantinduction.electrical.Electrical;
import resonantinduction.electrical.transformer.RenderTransformer;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalClass;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.electricity.IElectricalNetwork;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.electricity.IVoltageOutput;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyInterface;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorHelper;

@UniversalClass
public class PartTransformer
extends PartFace
implements IVoltageOutput,
IEnergyInterface {
    private boolean stepUp = true;
    public byte multiplier = (byte)2;

    public void preparePlacement(int side, int facing) {
        this.placementSide = ForgeDirection.getOrientation((int)side);
        this.facing = (byte)(facing - 2);
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.multiplier = packet.readByte();
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.multiplier);
    }

    public boolean stepUp() {
        return this.stepUp;
    }

    public boolean doesTick() {
        return false;
    }

    protected ItemStack getItem() {
        return new ItemStack(Electrical.itemTransformer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(codechicken.lib.vec.Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderTransformer.INSTANCE.render(this, pos.x, pos.y, pos.z);
        }
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.stepUp = nbt.func_74767_n("stepUp");
        this.multiplier = nbt.func_74771_c("multiplier");
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74757_a("stepUp", this.stepUp);
        nbt.func_74774_a("multiplier", this.multiplier);
    }

    public String getType() {
        return "resonant_induction_transformer";
    }

    public boolean canConnect(ForgeDirection direction, Object obj) {
        return obj instanceof IEnergyInterface && (direction == this.getAbsoluteFacing() || direction == this.getAbsoluteFacing().getOpposite());
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        TileEntity tile;
        if (from == this.getAbsoluteFacing() && CompatibilityModule.isHandler((Object)(tile = VectorHelper.getTileEntityFromSide((World)this.world(), (Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (ForgeDirection)from.getOpposite())))) {
            long voltage;
            if (tile instanceof IVoltageInput && (voltage = this.getVoltageOutput(from.getOpposite())) != ((IVoltageInput)tile).getVoltageInput(from)) {
                ((IVoltageInput)tile).onWrongVoltage(from, voltage);
            }
            return CompatibilityModule.receiveEnergy((Object)tile, (ForgeDirection)from, (long)receive, (boolean)doReceive);
        }
        return 0L;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        return 0L;
    }

    public long getVoltageOutput(ForgeDirection from) {
        if (from == this.getAbsoluteFacing().getOpposite()) {
            TileEntity inputTile = VectorHelper.getTileEntityFromSide((World)this.world(), (Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (ForgeDirection)this.getAbsoluteFacing());
            long inputVoltage = UniversalElectricity.DEFAULT_VOLTAGE;
            if (inputTile instanceof IConductor) {
                IConductor conductor = (IConductor)((IConductor)inputTile).getInstance(this.placementSide);
                if (conductor != null && conductor.getNetwork() instanceof IElectricalNetwork) {
                    inputVoltage = ((IElectricalNetwork)conductor.getNetwork()).getVoltage();
                }
            } else if (inputTile instanceof IVoltageOutput) {
                inputVoltage = ((IVoltageOutput)inputTile).getVoltageOutput(from);
            }
            if (inputVoltage <= 0L) {
                inputVoltage = UniversalElectricity.DEFAULT_VOLTAGE;
            }
            if (this.stepUp()) {
                return inputVoltage * (long)(this.multiplier + 2);
            }
            return inputVoltage / (long)(this.multiplier + 2);
        }
        return 0L;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        if (WrenchUtility.isUsableWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)this.x(), (int)this.y(), (int)this.z())) {
            if (!this.world().field_72995_K) {
                if (player.func_70093_af()) {
                    this.multiplier = (byte)((this.multiplier + 1) % 3);
                    this.sendDescUpdate();
                    return true;
                }
                WrenchUtility.damageWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)this.x(), (int)this.y(), (int)this.z());
                this.facing = (byte)((this.facing + 1) % 4);
                this.sendDescUpdate();
                this.tile().notifyPartChange((TMultiPart)this);
            }
            return true;
        }
        boolean bl = this.stepUp = !this.stepUp;
        if (!this.world().field_72995_K) {
            player.func_71035_c("Transformer set to step " + (this.stepUp ? "up" : "down") + ".");
        }
        return true;
    }
}

