/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire;

import codechicken.lib.colour.ColourRGBA;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum EnumWireMaterial {
    COPPER("Copper", 1.68f, 5, 200L, 184, 115, 51),
    TIN("Tin", 3.1f, 1, 100L, 132, 132, 130),
    IRON("Iron", 3.0f, 3, 800L, 97, 102, 105),
    ALUMINUM("Aluminum", 2.6f, 10, 600L, 215, 205, 181),
    SILVER("Silver", 1.59f, 5, 700L, 192, 192, 192),
    SUPERCONDUCTOR("Superconductor", 0.0f, 10, 1000000L, 255, 255, 1);

    public final float resistance;
    public final int damage;
    public final long maxAmps;
    public final ColourRGBA color;
    private ItemStack wire;
    private final String name;

    private EnumWireMaterial(String name, float resistance, int electrocutionDamage, long maxAmps, int r, int g, int b) {
        this.name = name;
        this.resistance = resistance / 100.0f;
        this.damage = electrocutionDamage;
        this.maxAmps = maxAmps;
        this.color = new ColourRGBA(r, g, b, 255);
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getWire() {
        return this.getWire(1);
    }

    public ItemStack getWire(int amount) {
        ItemStack returnStack = this.wire.func_77946_l();
        returnStack.field_77994_a = amount;
        return returnStack;
    }

    public void setWire(ItemStack item) {
        if (this.wire == null) {
            this.wire = item;
            OreDictionary.registerOre((String)(this.getName().toLowerCase() + "Wire"), (ItemStack)this.wire);
        }
    }

    public void setWire(Item item) {
        this.setWire(new ItemStack(item, 1, this.ordinal()));
    }

    public void setWire(Block block) {
        this.setWire(new ItemStack(block, 1, this.ordinal()));
    }
}

