/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire;

import codechicken.multipart.TMultiPart;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import resonantinduction.core.prefab.part.PartAdvanced;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalClass;
import universalelectricity.api.energy.EnergyNetworkLoader;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyNetwork;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorHelper;

@UniversalClass
@Deprecated
public abstract class PartConductor
extends PartAdvanced
implements IConductor {
    private IEnergyNetwork network;
    protected Object[] connections = new Object[6];

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        return this.getNetwork().produce((IConductor)this, from.getOpposite(), receive, doReceive);
    }

    public long onExtractEnergy(ForgeDirection from, long request, boolean doExtract) {
        return 0L;
    }

    public IEnergyNetwork getNetwork() {
        if (this.network == null) {
            this.setNetwork(EnergyNetworkLoader.getNewNetwork((IConductor[])new IConductor[]{this}));
        }
        return this.network;
    }

    public void setNetwork(IEnergyNetwork network) {
        this.network = network;
    }

    public boolean doesTick() {
        return false;
    }

    public Object[] getConnections() {
        return this.connections;
    }

    public boolean canConnect(ForgeDirection direction, Object source) {
        Vector3 connectPos = new Vector3((TileEntity)this.tile()).translate(direction);
        TileEntity connectTile = connectPos.getTileEntity((IBlockAccess)this.world());
        if (connectTile instanceof IConductor) {
            return false;
        }
        return CompatibilityModule.isHandler((Object)connectTile);
    }

    public abstract boolean canConnectTo(Object var1);

    protected void recalculateConnections() {
        this.connections = new Object[6];
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            ForgeDirection side = ForgeDirection.getOrientation((int)i);
            if (!this.canConnect(side, (Object)this)) continue;
            TileEntity tileEntity = VectorHelper.getTileEntityFromSide((World)this.world(), (Vector3)new Vector3((TileEntity)this.tile()), (ForgeDirection)side);
            this.connections[i] = tileEntity;
        }
    }

    public void onWorldJoin() {
        if (this.tile() instanceof IEnergyTile && !this.world().field_72995_K) {
            boolean foundAnotherPart = false;
            for (int i = 0; i < this.tile().partList().size(); ++i) {
                TMultiPart part = this.tile().partMap(i);
                if (!(part instanceof IEnergyTile) || part == this) continue;
                foundAnotherPart = true;
                break;
            }
            if (!foundAnotherPart) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.tile()));
            }
        }
    }

    public void preRemove() {
        if (!this.world().field_72995_K) {
            this.getNetwork().split((IConnector)this);
            if (this.tile() instanceof IEnergyTile) {
                boolean foundAnotherPart = false;
                for (int i = 0; i < this.tile().partList().size(); ++i) {
                    TMultiPart part = this.tile().partMap(i);
                    if (!(part instanceof IEnergyTile) || part == this) continue;
                    foundAnotherPart = true;
                    break;
                }
                if (!foundAnotherPart) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.tile()));
                }
            }
        }
        super.preRemove();
    }

    public IConnector<IEnergyNetwork> getInstance(ForgeDirection dir) {
        return this;
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74772_a("savedBuffer", this.getNetwork().getBufferOf((IConductor)this));
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.getNetwork().setBufferFor((IConductor)this, nbt.func_74763_f("savedBuffer"));
    }

    public String toString() {
        return "[PartConductor]" + this.x() + "x " + this.y() + "y " + this.z() + "z ";
    }
}

