/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire.framed;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.FloatBuffer;
import java.util.Map;
import net.minecraft.item.ItemDye;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import resonantinduction.core.prefab.part.PartFramedConnection;
import resonantinduction.core.render.InvertX;
import resonantinduction.electrical.wire.EnumWireMaterial;
import resonantinduction.electrical.wire.framed.PartFramedWire;

@SideOnly(value=Side.CLIENT)
public class RenderFramedWire {
    public static final ResourceLocation WIRE_SHINE = new ResourceLocation("resonantinduction", "models/white.png");
    public static final Map<String, CCModel> models;
    public static final Map<String, CCModel> shinyModels;
    public static Icon wireIcon;
    public static Icon lainWireIcon;
    public static Icon insulationIcon;
    public static Icon breakIcon;
    public static FloatBuffer location;
    public static FloatBuffer specular;
    public static FloatBuffer zero;
    public static FloatBuffer defaultAmbient;
    public static final RenderFramedWire INSTANCE;

    public static void loadBuffer(FloatBuffer buffer, float ... src) {
        buffer.clear();
        buffer.put(src);
        buffer.flip();
    }

    public void renderShine(PartFramedWire wire, double x, double y, double z, float f) {
        if (wire != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)769);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)16384);
            GL11.glDisable((int)16385);
            GL11.glEnable((int)16387);
            GL11.glLight((int)16387, (int)4611, (FloatBuffer)location);
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            GL11.glLightModel((int)2899, (FloatBuffer)zero);
            CCRenderState.reset();
            CCRenderState.useNormals((boolean)true);
            CCRenderState.changeTexture((ResourceLocation)WIRE_SHINE);
            CCRenderState.startDrawing((int)7);
            this.renderSideShine(ForgeDirection.UNKNOWN, wire);
            byte renderSides = wire.getAllCurrentConnections();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!PartFramedConnection.connectionMapContainsSide((byte)renderSides, (ForgeDirection)side)) continue;
                this.renderSideShine(side, wire);
            }
            CCRenderState.draw();
            GL11.glDisable((int)2896);
            GL11.glEnable((int)16384);
            GL11.glEnable((int)16385);
            GL11.glDisable((int)16387);
            GL11.glLightModel((int)2899, (FloatBuffer)defaultAmbient);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPopMatrix();
        }
    }

    public void renderStatic(PartFramedWire wire) {
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.useModelColours((boolean)true);
        CCRenderState.setBrightness((IBlockAccess)wire.world(), (int)wire.x(), (int)wire.y(), (int)wire.z());
        this.renderSide(ForgeDirection.UNKNOWN, wire);
        byte renderSides = wire.getAllCurrentConnections();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!PartFramedConnection.connectionMapContainsSide((byte)renderSides, (ForgeDirection)side)) continue;
            this.renderSide(side, wire);
        }
    }

    public void renderSide(ForgeDirection side, PartFramedWire wire) {
        String name = side.name().toLowerCase();
        name = name.equals("unknown") ? "center" : name;
        ColourRGBA colour = ((EnumWireMaterial)wire.getMaterial()).color;
        this.renderPart(wireIcon, models.get(name), wire.x(), wire.y(), wire.z(), (Colour)colour);
        if (wire.isInsulated()) {
            ColourARGB insulationColour = new ColourARGB(ItemDye.field_77859_b[wire.getColor()]);
            insulationColour.a = (byte)-1;
            this.renderPart(insulationIcon, models.get(name + "Insulation"), wire.x(), wire.y(), wire.z(), (Colour)insulationColour);
        }
    }

    public void renderSideShine(ForgeDirection side, PartFramedWire wire) {
        String name = side.name().toLowerCase();
        name = name.equals("unknown") ? "center" : name;
        this.renderPartShine(shinyModels.get(name));
    }

    public void renderPart(Icon icon, CCModel cc, double x, double y, double z, Colour colour) {
        cc.render(0, cc.verts.length, (Transformation)Rotation.sideOrientation((int)0, (int)Rotation.rotationTo((int)0, (int)2)).at(Vector3.center).with((Transformation)new Translation(x, y, z)), (IUVTransformation)new IconTransformation(icon), (IVertexModifier)new ColourMultiplier(colour));
    }

    public void renderPartShine(CCModel cc) {
        cc.render(null, 0.0, 0.0);
    }

    static {
        location = BufferUtils.createFloatBuffer((int)4);
        specular = BufferUtils.createFloatBuffer((int)4);
        zero = BufferUtils.createFloatBuffer((int)4);
        defaultAmbient = BufferUtils.createFloatBuffer((int)4);
        INSTANCE = new RenderFramedWire();
        models = CCModel.parseObjModels((ResourceLocation)new ResourceLocation("resonantinduction", "models/wire.obj"), (int)7, (Transformation)new InvertX());
        for (CCModel c : models.values()) {
            c.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            c.computeLighting(LightModel.standardLightModel);
            c.shrinkUVs(5.0E-4);
        }
        shinyModels = CCModel.parseObjModels((ResourceLocation)new ResourceLocation("resonantinduction", "models/wireShine.obj"), (int)7, (Transformation)new InvertX());
        for (CCModel c : shinyModels.values()) {
            c.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            c.computeLighting(LightModel.standardLightModel);
            c.shrinkUVs(5.0E-4);
        }
        RenderFramedWire.loadBuffer(location, 0.0f, 0.0f, 0.0f, 1.0f);
        RenderFramedWire.loadBuffer(specular, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderFramedWire.loadBuffer(zero, 0.0f, 0.0f, 0.0f, 0.0f);
        RenderFramedWire.loadBuffer(defaultAmbient, 0.4f, 0.4f, 0.4f, 1.0f);
        GL11.glLightModel((int)2899, (FloatBuffer)zero);
        GL11.glLight((int)16387, (int)4610, (FloatBuffer)specular);
        GL11.glMaterial((int)1028, (int)4610, (FloatBuffer)specular);
        GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)zero);
        GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)zero);
        GL11.glMaterialf((int)1028, (int)5633, (float)128.0f);
    }
}

