/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.quantum.gate;

import calclavia.api.mffs.fortron.FrequencyGrid;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import resonant.api.IExternalInventory;
import resonant.api.IExternalInventoryBox;
import resonant.api.blocks.IBlockFrequency;
import resonant.lib.utility.inventory.ExternalInventory;
import resonantinduction.electrical.Electrical;
import resonantinduction.quantum.gate.IQuantumGate;
import resonantinduction.quantum.gate.QuantumGateManager;
import resonantinduction.quantum.gate.RenderQuantumGlyph;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class PartQuantumGlyph
extends JCuboidPart
implements TSlottedPart,
JNormalOcclusion,
IQuantumGate,
IExternalInventory {
    public static final int MAX_GLYPH = 4;
    static final Cuboid6[] bounds = new Cuboid6[15];
    private byte slot;
    byte number;
    int ticks;
    static final HashMap<Integer, FluidTank> quantumTanks;
    static final HashMap<Integer, IExternalInventoryBox> quantumInventories;

    public void preparePlacement(int side, int itemDamage) {
        this.slot = (byte)side;
        this.number = (byte)itemDamage;
    }

    public void onWorldJoin() {
        if (((IQuantumGate)this.tile()).getFrequency() != -1) {
            FrequencyGrid.instance().register((IBlockFrequency)((IQuantumGate)this.tile()));
        }
    }

    public void preRemove() {
        FrequencyGrid.instance().unregister((IBlockFrequency)((IQuantumGate)this.tile()));
    }

    public void onEntityCollision(Entity entity) {
        if (!this.world().field_72995_K) {
            if (entity instanceof EntityPlayer && !((EntityPlayer)entity).func_70093_af()) {
                return;
            }
            this.transport(entity);
        }
    }

    @Override
    public void transport(Entity entity) {
        if (this.ticks % 10 == 0 && ((IQuantumGate)this.tile()).getFrequency() != -1) {
            IQuantumGate gate;
            VectorWorld position;
            Set frequencyBlocks = FrequencyGrid.instance().get(((IQuantumGate)this.tile()).getFrequency());
            ArrayList<IQuantumGate> gates = new ArrayList<IQuantumGate>();
            for (IBlockFrequency frequencyBlock : frequencyBlocks) {
                if (!(frequencyBlock instanceof IQuantumGate)) continue;
                gates.add((IQuantumGate)frequencyBlock);
            }
            gates.remove(this.tile());
            if (gates.size() > 0 && QuantumGateManager.moveEntity(entity, position = new VectorWorld((TileEntity)(gate = (IQuantumGate)gates.get(gates.size() > 1 ? entity.field_70170_p.field_73012_v.nextInt(gates.size() - 1) : 0))).translate(0.5, 2.0, 0.5))) {
                this.world().func_72956_a(entity, "mob.endermen.portal", 1.0f, 1.0f);
            }
        }
    }

    public void update() {
        int frequency;
        if (this.ticks == 0) {
            FrequencyGrid.instance().register((IBlockFrequency)((IQuantumGate)this.tile()));
        }
        ++this.ticks;
        if (this.world().field_72995_K && (frequency = ((IBlockFrequency)this.tile()).getFrequency()) > 0) {
            float deviation = 1.0f;
            Vector3 center = new Vector3((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5);
            Electrical.proxy.renderElectricShock(this.world(), center, center.clone().translate(Math.random() * (double)deviation - (double)(deviation / 2.0f), Math.random() * (double)deviation - (double)(deviation / 2.0f), Math.random() * (double)deviation - (double)(deviation / 2.0f)));
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack itemStack) {
        if (player.func_70093_af()) {
            if (!this.world().field_72995_K) {
                this.transport((Entity)player);
                return true;
            }
        } else {
            int frequency = ((IBlockFrequency)this.tile()).getFrequency();
            if (frequency > -1) {
                if (!this.world().field_72995_K) {
                    System.out.println(this.func_70301_a(0));
                    player.func_71035_c("Quantum Gate Frequency: " + frequency);
                }
                return true;
            }
        }
        return false;
    }

    public String getType() {
        return "resonant_induction_quantum_glyph";
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(codechicken.lib.vec.Vector3 pos, float frame, int pass) {
        RenderQuantumGlyph.INSTANCE.render(this, pos.x, pos.y, pos.z);
    }

    public Cuboid6 getBounds() {
        if (this.slot < bounds.length && bounds[this.slot] != null) {
            return bounds[this.slot];
        }
        return new Cuboid6(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    public int getSlotMask() {
        return 1 << this.slot;
    }

    protected ItemStack getItem() {
        return new ItemStack(Electrical.itemQuantumGlyph, 1, (int)this.number);
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItem());
        return drops;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public void readDesc(MCDataInput packet) {
        this.load(packet.readNBTTagCompound());
    }

    public void writeDesc(MCDataOutput packet) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.save(nbt);
        packet.writeNBTTagCompound(nbt);
    }

    public void load(NBTTagCompound nbt) {
        int frequency;
        this.slot = nbt.func_74771_c("side");
        this.number = nbt.func_74771_c("number");
        if (nbt.func_74764_b("frequency") && (frequency = nbt.func_74762_e("frequency")) != -1) {
            ExternalInventory savedInventory = new ExternalInventory(null, (IExternalInventory)this, 1);
            savedInventory.load(nbt);
            quantumInventories.put(frequency, (IExternalInventoryBox)savedInventory);
            FluidTank tank = new FluidTank(1000);
            tank.readFromNBT(nbt);
            quantumTanks.put(frequency, tank);
        }
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74774_a("side", this.slot);
        nbt.func_74774_a("number", this.number);
        if (this.tile() != null) {
            int frequency = ((IQuantumGate)this.tile()).getFrequency();
            nbt.func_74768_a("frequency", frequency);
            if (frequency != -1) {
                this.getInventory().save(nbt);
                this.getQuantumTank().writeToNBT(nbt);
            }
        }
    }

    public int getFrequency() {
        return this.number;
    }

    public void setFrequency(int frequency) {
    }

    @Override
    public FluidTank getQuantumTank() {
        int frequency = ((IQuantumGate)this.tile()).getFrequency();
        if (frequency > -1) {
            if (!quantumTanks.containsKey(frequency)) {
                quantumTanks.put(frequency, new FluidTank(1000));
            }
            return quantumTanks.get(frequency);
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (((IQuantumGate)this.tile()).getFrequency() != -1) {
            return this.getQuantumTank().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (((IQuantumGate)this.tile()).getFrequency() != -1) {
            return this.getQuantumTank().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (((IQuantumGate)this.tile()).getFrequency() != -1) {
            return this.getQuantumTank().drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return ((IQuantumGate)this.tile()).getFrequency() != -1;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ((IQuantumGate)this.tile()).getFrequency() != -1;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getQuantumTank().getInfo()};
    }

    public IExternalInventoryBox getInventory() {
        int frequency = ((IQuantumGate)this.tile()).getFrequency();
        if (frequency > -1) {
            if (!quantumInventories.containsKey(frequency)) {
                quantumInventories.put(frequency, (IExternalInventoryBox)new ExternalInventory(null, (IExternalInventory)this, 1));
            }
            return quantumInventories.get(frequency);
        }
        return null;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (this.getInventory() == null) {
            return null;
        }
        return this.getInventory().func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.getInventory().func_70298_a(i, j);
    }

    public void incrStackSize(int slot, ItemStack itemStack) {
        if (this.func_70301_a(slot) == null) {
            this.func_70299_a(slot, itemStack.func_77946_l());
        } else if (this.func_70301_a(slot).func_77969_a(itemStack)) {
            this.func_70301_a((int)slot).field_77994_a += itemStack.field_77994_a;
        }
        this.func_70296_d();
    }

    public ItemStack func_70304_b(int i) {
        if (this.getInventory() == null) {
            return null;
        }
        return this.getInventory().func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        if (this.getInventory() != null) {
            this.getInventory().func_70299_a(i, itemStack);
        }
    }

    public String func_70303_b() {
        return "Quantum Gate";
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        if (this.getInventory() == null) {
            return 0;
        }
        return this.getInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.getInventory() == null) {
            return false;
        }
        return this.getInventory().func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.getInventory() == null) {
            return false;
        }
        return this.getInventory().func_94041_b(i, itemstack);
    }

    public int[] func_94128_d(int var1) {
        if (this.getInventory() == null) {
            return new int[0];
        }
        return this.getInventory().func_94128_d(var1);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (this.getInventory() == null) {
            return false;
        }
        return this.getInventory().func_102007_a(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        if (this.getInventory() == null) {
            return false;
        }
        return this.getInventory().func_102008_b(i, itemstack, j);
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return this.getInventory() != null;
    }

    public boolean canRemove(ItemStack stack, int slot, ForgeDirection side) {
        return this.getInventory() != null;
    }

    public void func_70296_d() {
    }

    static {
        float expansion = -0.02f;
        PartQuantumGlyph.bounds[7] = new Cuboid6(0.0, 0.0, 0.0, 0.5, 0.5, 0.5).expand((double)expansion);
        PartQuantumGlyph.bounds[9] = new Cuboid6(0.0, 0.0, 0.5, 0.5, 0.5, 1.0).expand((double)expansion);
        PartQuantumGlyph.bounds[11] = new Cuboid6(0.5, 0.0, 0.0, 1.0, 0.5, 0.5).expand((double)expansion);
        PartQuantumGlyph.bounds[13] = new Cuboid6(0.5, 0.0, 0.5, 1.0, 0.5, 1.0).expand((double)expansion);
        PartQuantumGlyph.bounds[8] = new Cuboid6(0.0, 0.5, 0.0, 0.5, 1.0, 0.5).expand((double)expansion);
        PartQuantumGlyph.bounds[10] = new Cuboid6(0.0, 0.5, 0.5, 0.5, 1.0, 1.0).expand((double)expansion);
        PartQuantumGlyph.bounds[12] = new Cuboid6(0.5, 0.5, 0.0, 1.0, 1.0, 0.5).expand((double)expansion);
        PartQuantumGlyph.bounds[14] = new Cuboid6(0.5, 0.5, 0.5, 1.0, 1.0, 1.0).expand((double)expansion);
        quantumTanks = new HashMap();
        quantumInventories = new HashMap();
    }
}

