/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.inventory.ISelectiveInventory;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.core.gui.buttons.IButtonTextureSet;
import buildcraft.core.gui.buttons.IMultiButtonState;
import buildcraft.core.gui.buttons.MultiButtonController;
import buildcraft.core.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.gui.tooltips.ToolTip;
import buildcraft.core.gui.tooltips.ToolTipLine;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.IClientState;
import buildcraft.core.network.IGuiReturnHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.pipes.PipeItemsWood;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsEmerald
extends PipeItemsWood
implements IClientState,
IGuiReturnHandler {
    private final MultiButtonController stateController = MultiButtonController.getController((int)ButtonState.BLOCKING.ordinal(), (IMultiButtonState[])ButtonState.values());
    private final SimpleInventory filters = new SimpleInventory(9, "Filters", 1);
    private int currentFilter = 0;

    public PipeItemsEmerald(int itemID) {
        super(itemID);
        this.standardIconIndex = PipeIconProvider.TYPE.PipeItemsEmerald_Standard.ordinal();
        this.solidIconIndex = PipeIconProvider.TYPE.PipeAllEmerald_Solid.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().field_77993_c < Block.field_71973_m.length && Block.field_71973_m[entityplayer.func_71045_bC().field_77993_c] instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer)) {
            return true;
        }
        if (!CoreProxy.proxy.isRenderWorld(this.container.field_70331_k)) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 52, this.container.field_70331_k, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        }
        return true;
    }

    @Override
    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory instanceof ISelectiveInventory) {
            ItemStack[] stacks = ((ISelectiveInventory)inventory).extractItem(new ItemStack[]{this.getCurrentFilter()}, false, doRemove, from, (int)this.powerHandler.getEnergyStored());
            if (doRemove) {
                for (ItemStack stack : stacks) {
                    if (stack == null) continue;
                    this.powerHandler.useEnergy(stack.field_77994_a, stack.field_77994_a, true);
                }
                this.incrementFilter();
            }
            return stacks;
        }
        if (inventory instanceof ISpecialInventory) {
            ItemStack[] stacks = ((ISpecialInventory)inventory).extractItem(false, from, (int)this.powerHandler.getEnergyStored());
            if (stacks != null) {
                for (ItemStack stack : stacks) {
                    if (stack == null) continue;
                    boolean matches = false;
                    for (int i = 0; i < this.filters.func_70302_i_(); ++i) {
                        ItemStack filter = this.filters.func_70301_a(i);
                        if (filter == null || !filter.func_77969_a(stack)) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    return null;
                }
                if (doRemove) {
                    for (ItemStack stack : stacks = ((ISpecialInventory)inventory).extractItem(true, from, (int)this.powerHandler.getEnergyStored())) {
                        if (stack == null) continue;
                        this.powerHandler.useEnergy(stack.field_77994_a, stack.field_77994_a, true);
                    }
                }
            }
            return stacks;
        }
        IInventory inv = Utils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (doRemove && this.stateController.getButtonState() == ButtonState.NONBLOCKING && result == null) {
            for (int count = 1; result == null && count < this.filters.func_70302_i_(); ++count) {
                this.incrementFilter();
                result = this.checkExtractGeneric(inv, doRemove, from);
            }
        }
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    private void incrementFilter() {
        ++this.currentFilter;
        for (int count = 0; this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_()) == null && count < this.filters.func_70302_i_(); ++count) {
            ++this.currentFilter;
        }
    }

    private ItemStack getCurrentFilter() {
        ItemStack filter = this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_());
        if (filter == null) {
            this.incrementFilter();
        }
        return this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_());
    }

    @Override
    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int i : inventory.func_94128_d(from.ordinal())) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            ItemStack filter = this.getCurrentFilter();
            if (filter == null) {
                return null;
            }
            if (!filter.func_77969_a(stack) || !inventory.func_102008_b(i, stack, from.ordinal())) continue;
            if (doRemove) {
                this.incrementFilter();
                return inventory.func_70298_a(i, (int)this.powerHandler.useEnergy(1.0f, stack.field_77994_a, true));
            }
            return stack;
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        this.currentFilter = nbt.func_74762_e("currentFilter");
        this.stateController.readFromNBT(nbt, "state");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
        nbt.func_74768_a("currentFilter", this.currentFilter);
        this.stateController.writeToNBT(nbt, "state");
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        NBTBase nbt = NBTBase.func_74739_b((DataInput)data);
        if (nbt instanceof NBTTagCompound) {
            this.readFromNBT((NBTTagCompound)nbt);
        }
    }

    public IInventory getFilters() {
        return this.filters;
    }

    public MultiButtonController getStateController() {
        return this.stateController;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.stateController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.stateController.setCurrentState(data.readByte());
    }

    public static enum ButtonState implements IMultiButtonState
    {
        BLOCKING("gui.pipes.emerald.blocking"),
        NONBLOCKING("gui.pipes.emerald.nonblocking");

        private final String label;
        private final ToolTip tip = new ToolTip(500){

            @Override
            public void refresh() {
                this.clear();
                ButtonState.this.tip.add(new ToolTipLine(StringUtils.localize(ButtonState.this.label + ".tip")));
            }
        };

        private ButtonState(String label) {
            this.label = label;
        }

        @Override
        public String getLabel() {
            return StringUtils.localize(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

