/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.StackFilter;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsObsidian
extends Pipe<PipeTransportItems>
implements IPowerReceptor {
    private static final PowerHandler.PerditionCalculator PERDITION = new PowerHandler.PerditionCalculator(0.5f);
    private PowerHandler powerHandler;
    private int[] entitiesDropped = new int[32];
    private int entitiesDroppedIndex = 0;

    public PipeItemsObsidian(int itemID) {
        super(new PipeTransportItems(), itemID);
        Arrays.fill(this.entitiesDropped, -1);
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.powerHandler.configure(1.0f, 64.0f, 1.0f, 256.0f);
        this.powerHandler.setPerdition(PERDITION);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return PipeIconProvider.TYPE.PipeItemsObsidian.ordinal();
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        super.onEntityCollidedWithBlock(entity);
        if (entity.field_70128_L) {
            return;
        }
        if (this.canSuck(entity, 0)) {
            this.pullItemIntoPipe(entity, 0);
        }
    }

    private AxisAlignedBB getSuckingBox(ForgeDirection orientation, int distance) {
        if (orientation == ForgeDirection.UNKNOWN) {
            return null;
        }
        Position p1 = new Position(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n, orientation);
        Position p2 = new Position(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n, orientation);
        switch (orientation) {
            case EAST: {
                p1.x += (double)distance;
                p2.x += (double)(1 + distance);
                break;
            }
            case WEST: {
                p1.x -= (double)(distance - 1);
                p2.x -= (double)distance;
                break;
            }
            case UP: 
            case DOWN: {
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case SOUTH: {
                p1.z += (double)distance;
                p2.z += (double)(distance + 1);
                break;
            }
            default: {
                p1.z -= (double)(distance - 1);
                p2.z -= (double)distance;
            }
        }
        switch (orientation) {
            case EAST: 
            case WEST: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case UP: {
                p1.y += (double)(distance + 1);
                p2.y += (double)distance;
                break;
            }
            case DOWN: {
                p1.y -= (double)(distance - 1);
                p2.y -= (double)distance;
                break;
            }
            default: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
            }
        }
        Position min = p1.min(p2);
        Position max = p1.max(p2);
        return AxisAlignedBB.func_72332_a().func_72299_a(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        for (int j = 1; j < 5; ++j) {
            if (!this.suckItem(j)) continue;
            return;
        }
    }

    private boolean suckItem(int distance) {
        AxisAlignedBB box = this.getSuckingBox(this.getOpenOrientation(), distance);
        if (box == null) {
            return false;
        }
        List discoveredEntities = this.container.field_70331_k.func_72872_a(Entity.class, box);
        for (Entity entity : discoveredEntities) {
            ForgeDirection openOrientation;
            ITransactor trans;
            ItemStack stack;
            if (this.canSuck(entity, distance)) {
                this.pullItemIntoPipe(entity, distance);
                return true;
            }
            if (distance != 1 || !(entity instanceof EntityMinecartChest)) continue;
            EntityMinecartChest cart = (EntityMinecartChest)entity;
            if (cart.field_70128_L || (stack = (trans = Transactor.getTransactorFor(cart)).remove(StackFilter.ALL, openOrientation = this.getOpenOrientation(), false)) == null || this.powerHandler.useEnergy(1.0f, 1.0f, true) != 1.0f) continue;
            trans.remove(StackFilter.ALL, openOrientation, true);
            EntityItem entityitem = new EntityItem(this.container.field_70331_k, cart.field_70165_t, cart.field_70163_u + (double)0.3f, cart.field_70161_v, stack);
            entityitem.field_70293_c = 10;
            this.container.field_70331_k.func_72838_d((Entity)entityitem);
            this.pullItemIntoPipe((Entity)entityitem, 1);
            return true;
        }
        return false;
    }

    public void pullItemIntoPipe(Entity entity, int distance) {
        if (CoreProxy.proxy.isRenderWorld(this.container.field_70331_k)) {
            return;
        }
        ForgeDirection orientation = this.getOpenOrientation().getOpposite();
        if (orientation != ForgeDirection.UNKNOWN) {
            this.container.field_70331_k.func_72956_a(entity, "random.pop", 0.2f, ((this.container.field_70331_k.field_73012_v.nextFloat() - this.container.field_70331_k.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            ItemStack stack = null;
            double speed = 0.01f;
            if (entity instanceof EntityItem) {
                EntityItem item = (EntityItem)entity;
                ItemStack contained = item.func_92059_d();
                CoreProxy.proxy.obsidianPipePickup(this.container.field_70331_k, item, this.container);
                float energyUsed = this.powerHandler.useEnergy(distance, contained.field_77994_a * distance, true);
                if (distance == 0 || energyUsed / (float)distance == (float)contained.field_77994_a) {
                    stack = contained;
                    CoreProxy.proxy.removeEntity(entity);
                } else {
                    stack = contained.func_77979_a((int)(energyUsed / (float)distance));
                }
                speed = Math.sqrt(item.field_70159_w * item.field_70159_w + item.field_70181_x * item.field_70181_x + item.field_70179_y * item.field_70179_y);
                speed = speed / 2.0 - 0.05;
                if (speed < 0.01) {
                    speed = 0.01;
                }
            } else if (entity instanceof EntityArrow) {
                this.powerHandler.useEnergy(distance, distance, true);
                stack = new ItemStack(Item.field_77704_l, 1);
                CoreProxy.proxy.removeEntity(entity);
            }
            TravelingItem passive = new TravelingItem((double)this.container.field_70329_l + 0.5, (float)this.container.field_70330_m + TransportUtils.getPipeFloorOf(stack), (double)this.container.field_70327_n + 0.5, stack);
            passive.setSpeed((float)speed);
            ((PipeTransportItems)this.transport).injectItem(passive, orientation);
        }
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        this.entitiesDroppedIndex = this.entitiesDroppedIndex + 1 >= this.entitiesDropped.length ? 0 : ++this.entitiesDroppedIndex;
        this.entitiesDropped[this.entitiesDroppedIndex] = event.entity.field_70157_k;
    }

    public boolean canSuck(Entity entity, int distance) {
        if (!entity.func_70089_S()) {
            return false;
        }
        if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            if (item.func_92059_d().field_77994_a <= 0) {
                return false;
            }
            for (int i = 0; i < this.entitiesDropped.length; ++i) {
                if (item.field_70157_k != this.entitiesDropped[i]) continue;
                return false;
            }
            return this.powerHandler.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        if (entity instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)entity;
            return arrow.field_70251_a == 1 && this.powerHandler.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        return false;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }
}

