/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.transport.IPipe;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;
import java.util.Locale;

public class TriggerPipeSignal
extends BCTrigger
implements ITriggerPipe {
    boolean active;
    IPipe.WireColor color;

    public TriggerPipeSignal(int legacyId, boolean active, IPipe.WireColor color) {
        super(legacyId, "buildcraft.pipe.wire.input." + color.name().toLowerCase(Locale.ENGLISH) + (active ? ".active" : ".inactive"));
        this.active = active;
        this.color = color;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.active) {
            switch (this.color) {
                case Red: {
                    return "Red Pipe Signal On";
                }
                case Blue: {
                    return "Blue Pipe Signal On";
                }
                case Green: {
                    return "Green Pipe Signal On";
                }
                case Yellow: {
                    return "Yellow Pipe Signal On";
                }
            }
        } else {
            switch (this.color) {
                case Red: {
                    return "Red Pipe Signal Off";
                }
                case Blue: {
                    return "Blue Pipe Signal Off";
                }
                case Green: {
                    return "Green Pipe Signal Off";
                }
                case Yellow: {
                    return "Yellow Pipe Signal Off";
                }
            }
        }
        return "";
    }

    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (this.active) {
            return pipe.signalStrength[this.color.ordinal()] > 0;
        }
        return pipe.signalStrength[this.color.ordinal()] == 0;
    }

    @Override
    public int getIconIndex() {
        if (this.active) {
            switch (this.color) {
                case Red: {
                    return 21;
                }
                case Blue: {
                    return 22;
                }
                case Green: {
                    return 23;
                }
                case Yellow: {
                    return 24;
                }
            }
        } else {
            switch (this.color) {
                case Red: {
                    return 25;
                }
                case Blue: {
                    return 26;
                }
                case Green: {
                    return 27;
                }
                case Yellow: {
                    return 28;
                }
            }
        }
        return -1;
    }
}

