/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.IRandomDisplayTick;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.PriorityBlockingQueue;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.core.utils.Pair2;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.EnumPipe;
import mrtjp.projectred.transportation.IRouteLayer;
import mrtjp.projectred.transportation.IWorldBroadcaster;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.LogisticPathFinder;
import mrtjp.projectred.transportation.RouteFX;
import mrtjp.projectred.transportation.RoutedPayload;
import mrtjp.projectred.transportation.Router;
import mrtjp.projectred.transportation.RouterServices;
import mrtjp.projectred.transportation.SyncResponse;
import net.minecraftforge.common.ForgeDirection;

public class RoutedJunctionPipePart
extends BasicPipePart
implements IWorldRouter,
IRouteLayer,
IWorldRequester,
IRandomDisplayTick {
    public int linkMap;
    public Router router;
    public String routerID;
    public Object routerIDLock = new Object();
    public boolean needsWork = true;
    public boolean firstTick = true;
    public static int pipes = 0;
    public int searchDelay = 0;
    private LinkedList<RoutedPayload> sendQueue = new LinkedList();
    private PriorityBlockingQueue<Pair2<RoutedPayload, Integer>> transitQueue = new PriorityBlockingQueue<Pair2<RoutedPayload, Integer>>(10, new TransitComparator());

    public RoutedJunctionPipePart() {
        this.searchDelay = ++pipes % Configurator.detectionFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Router getRouter() {
        if (this.needsWork) {
            return null;
        }
        if (this.router == null) {
            Object object = this.routerIDLock;
            synchronized (object) {
                UUID id = null;
                if (this.routerID != null && !this.routerID.isEmpty()) {
                    id = UUID.fromString(this.routerID);
                }
                this.router = RouterServices.instance.getOrCreateRouter(id, this);
            }
        }
        return this.router;
    }

    @Override
    public void itemEnroute(RoutedPayload r) {
        this.transitQueue.add((Pair2<RoutedPayload, Integer>)new Pair2((Object)r, (Object)200));
    }

    @Override
    public void itemArrived(RoutedPayload r) {
        this.removeFromTransitQueue(r);
        if (this instanceof IWorldRequester) {
            this.trackedItemReceived(r.payload);
        }
    }

    private void removeFromTransitQueue(RoutedPayload r) {
        Iterator<Pair2<RoutedPayload, Integer>> it = this.transitQueue.iterator();
        while (it.hasNext()) {
            Pair2<RoutedPayload, Integer> pair = it.next();
            if (pair.getValue1() != r) continue;
            it.remove();
            break;
        }
    }

    private void tickTransitQueue() {
        Iterator<Pair2<RoutedPayload, Integer>> it = this.transitQueue.iterator();
        while (it.hasNext()) {
            Pair2<RoutedPayload, Integer> pair = it.next();
            Integer val = (Integer)pair.getValue2();
            if (val == null) {
                val = 0;
            }
            Integer n = val;
            Integer n2 = val = Integer.valueOf(val - 1);
            if (val < 0) {
                it.remove();
                continue;
            }
            pair.setValue2((Object)val);
        }
    }

    protected int countInTransit(ItemKey key) {
        int count = 0;
        for (Pair2<RoutedPayload, Integer> pair : this.transitQueue) {
            Integer val = (Integer)pair.getValue2();
            ItemKeyStack stack = ((RoutedPayload)pair.getValue1()).payload;
            if (!stack.key().equals((Object)key)) continue;
            count += val.intValue();
        }
        return count;
    }

    @Override
    public void queueStackToSend(ye stack, int dirOfExtraction, SyncResponse path) {
        this.queueStackToSend(stack, dirOfExtraction, path.priority, path.responder);
    }

    @Override
    public void queueStackToSend(ye stack, int dirOfExtraction, RoutedPayload.SendPriority priority, int destination) {
        RoutedPayload r = new RoutedPayload(ItemKeyStack.get((ye)stack));
        r.input = ForgeDirection.getOrientation((int)dirOfExtraction);
        r.setPriority(priority);
        r.setDestination(destination);
        this.sendQueue.addLast(r);
    }

    private void dispatchQueuedPayload(RoutedPayload r) {
        this.injectPayload(r, r.input);
        Router dest = RouterServices.instance.getRouter(r.destinationIP);
        if (dest != null) {
            IWorldRouter wr = dest.getParent();
            wr.itemEnroute(r);
            RouteFX.spawnType1(RouteFX.color_sync, 8, new BlockCoord((asp)wr.getContainer().tile()), this.world());
        }
        RouteFX.spawnType1(RouteFX.color_send, 8, new BlockCoord((asp)this.tile()), this.world());
    }

    @Override
    public SyncResponse getLogisticPath(ItemKey stack, BitSet exclusions, boolean excludeStart) {
        LogisticPathFinder p = new LogisticPathFinder(this.getRouter(), stack);
        if (exclusions != null) {
            p.setExclusions(exclusions);
        }
        p.setExcludeSource(excludeStart).findBestResult();
        return p.getResult();
    }

    @Override
    public SyncResponse getSyncResponse(ItemKey item, SyncResponse rival) {
        return null;
    }

    @Override
    public final void update() {
        if (this.needsWork) {
            this.needsWork = false;
            this.coldBoot();
            return;
        }
        if (!this.world().I) {
            this.getRouter().update(this.world().I() % (long)Configurator.detectionFrequency == (long)this.searchDelay || this.firstTick);
        }
        super.update();
        this.firstTick = false;
        while (!this.sendQueue.isEmpty()) {
            this.dispatchQueuedPayload(this.sendQueue.removeFirst());
        }
        this.tickTransitQueue();
        if (this.world().I) {
            this.updateClient();
        } else {
            this.updateServer();
        }
    }

    protected void updateServer() {
    }

    protected void updateClient() {
        if (this.world().I() % (long)(Configurator.detectionFrequency * 20) == (long)this.searchDelay || this.firstTick) {
            for (int i = 0; i < 6; ++i) {
                if ((this.linkMap & 1 << i) == 0) continue;
                RouteFX.spawnType3(RouteFX.color_blink, 1, i, this.getCoords(), this.world());
            }
        }
    }

    private void coldBoot() {
        if (!this.world().I) {
            this.getRouter();
        }
    }

    @Override
    public boolean needsWork() {
        return this.needsWork;
    }

    @Override
    public boolean refreshState() {
        if (this.world().I) {
            return false;
        }
        int link = 0;
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.getRouter().LSAConnectionExists(d)) continue;
            link |= 1 << d.ordinal();
        }
        if (this.linkMap != link) {
            this.linkMap = link;
            this.sendLinkMapUpdate();
            return true;
        }
        return false;
    }

    @Override
    public BasicPipePart getContainer() {
        return this;
    }

    public boolean activate(uf player, ata hit, ye item) {
        return false;
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 51) {
            this.handleLinkMap(packet);
        } else {
            super.read(packet, switch_key);
        }
    }

    private void handleLinkMap(MCDataInput packet) {
        int old = this.linkMap;
        this.linkMap = packet.readUByte();
        int high = this.linkMap & ~old;
        int low = ~this.linkMap & old;
        BlockCoord bc = this.getCoords();
        for (int i = 0; i < 6; ++i) {
            if ((high & 1 << i) != 0) {
                RouteFX.spawnType3(RouteFX.color_linked, 1, i, bc, this.world());
            }
            if ((low & 1 << i) == 0) continue;
            RouteFX.spawnType3(RouteFX.color_unlinked, 1, i, bc, this.world());
        }
        this.tile().markRender();
    }

    public void sendLinkMapUpdate() {
        this.getWriteStream().writeByte(51).writeByte(this.linkMap);
    }

    @Override
    public ms getIcon(int side) {
        if ((this.linkMap & 1 << side) != 0) {
            return EnumPipe.ROUTEDJUNCTION.sprites[0];
        }
        return EnumPipe.ROUTEDJUNCTION.sprites[1];
    }

    @Override
    public String getType() {
        return "pr_rbasic";
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        pipes = Math.max(pipes - 1, 0);
        Router r = this.getRouter();
        if (r != null) {
            r.decommission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(by tag) {
        super.save(tag);
        Object object = this.routerIDLock;
        synchronized (object) {
            if (this.routerID == null || this.routerID.isEmpty()) {
                this.routerID = this.router != null ? this.getRouter().getID().toString() : UUID.randomUUID().toString();
            }
        }
        tag.a("rid", this.routerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(by tag) {
        super.load(tag);
        Object object = this.routerIDLock;
        synchronized (object) {
            this.routerID = tag.i("rid");
        }
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte(this.linkMap);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.linkMap = packet.readByte();
    }

    @Override
    public void resolveDestination(RoutedPayload r) {
        LogisticPathFinder f;
        if (this.needsWork()) {
            return;
        }
        int color = -1;
        r.output = ForgeDirection.UNKNOWN;
        r.refreshIP();
        if (r.destinationIP < 0 || r.destinationIP >= 0 && r.hasArrived) {
            r.resetTrip();
            f = new LogisticPathFinder(this.getRouter(), r.payload.key()).setExclusions(r.travelLog).findBestResult();
            if (f.getResult() != null) {
                r.setDestination(f.getResult().responder).setPriority(f.getResult().priority);
                color = RouteFX.color_route;
            }
        }
        r.refreshIP();
        if (r.destinationIP > 0 && r.destinationUUID.equals(this.getRouter().getID())) {
            r.output = this.getDirForIncomingItem(r);
            if (r.output == ForgeDirection.UNKNOWN) {
                r.resetTrip();
                f = new LogisticPathFinder(this.getRouter(), r.payload.key()).setExclusions(r.travelLog).findBestResult();
                if (f.getResult() != null) {
                    r.setDestination(f.getResult().responder).setPriority(f.getResult().priority);
                    color = RouteFX.color_route;
                }
            }
            r.hasArrived = true;
            this.itemArrived(r);
            r.travelLog.set(this.getRouter().getIPAddress());
            color = RouteFX.color_receive;
        }
        if (r.output == ForgeDirection.UNKNOWN) {
            r.output = this.getRouter().getExitDirection(r.destinationIP);
            color = RouteFX.color_relay;
        }
        if (r.output == ForgeDirection.UNKNOWN) {
            super.resolveDestination(r);
            r.resetTrip();
            r.travelLog.clear();
            color = RouteFX.color_routeLost;
        }
        RouteFX.spawnType1(color, 8, new BlockCoord((asp)this.tile()), this.world());
        this.adjustSpeed(r);
    }

    public ForgeDirection getDirForIncomingItem(RoutedPayload r) {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public void adjustSpeed(RoutedPayload r) {
        r.speed = r.priority.boost;
    }

    @Override
    public void trackedItemLost(ItemKeyStack s) {
    }

    @Override
    public void trackedItemReceived(ItemKeyStack s) {
    }

    @Override
    public int getActiveFreeSpace(ItemKey item) {
        return Integer.MAX_VALUE;
    }

    @Override
    public IWorldRouter getWorldRouter() {
        return this;
    }

    @Override
    public IWorldBroadcaster getBroadcaster() {
        if (this instanceof IWorldBroadcaster) {
            return (IWorldBroadcaster)((Object)this);
        }
        return null;
    }

    @Override
    public IWorldRequester getRequester() {
        return this;
    }

    @Override
    public abw getWorld() {
        return this.world();
    }

    @Override
    public BlockCoord getCoords() {
        return new BlockCoord((asp)this.tile());
    }

    public void randomDisplayTick(Random rand) {
    }

    private class TransitComparator
    implements Comparator<Pair2<RoutedPayload, Integer>> {
        private TransitComparator() {
        }

        @Override
        public int compare(Pair2<RoutedPayload, Integer> o1, Pair2<RoutedPayload, Integer> o2) {
            int c = (Integer)o2.getValue2() - (Integer)o1.getValue2();
            if (c == 0) {
                c = ((RoutedPayload)o2.getValue1()).payload.compareTo(((RoutedPayload)o1.getValue1()).payload);
            }
            return c;
        }
    }
}

