/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.Router;

public class RouterServices {
    public static RouterServices instance = new RouterServices();
    private final ArrayList<Router> routers = new ArrayList();
    private final Map<UUID, Integer> UUIDTable = new HashMap<UUID, Integer>();

    public Router getRouter(int id) {
        if (id < 0 || id >= this.routers.size()) {
            return null;
        }
        return this.routers.get(id);
    }

    public int getIPforUUID(UUID id) {
        if (id == null) {
            return -1;
        }
        Integer ip = this.UUIDTable.get(id);
        if (ip == null) {
            return -1;
        }
        return ip;
    }

    public void removeRouter(int id) {
        this.routers.set(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Router getOrCreateRouter(UUID uu, IWorldRouter holder) {
        ArrayList<Router> arrayList = this.routers;
        synchronized (arrayList) {
            for (Router r : this.routers) {
                if (r == null || r.getParent() != holder) continue;
                return r;
            }
            Router r = new Router(uu, holder);
            int newLease = r.getIPAddress();
            if (this.routers.size() <= newLease) {
                int newLength = (int)((double)newLease * 1.5) + 1;
                this.routers.ensureCapacity(newLength);
                while (this.routers.size() <= newLength) {
                    this.routers.add(null);
                }
            }
            this.routers.set(newLease, r);
            this.UUIDTable.put(r.getID(), r.getIPAddress());
            return r;
        }
    }

    public boolean routerExists(int ip) {
        if (ip < 0 || ip >= this.routers.size()) {
            return false;
        }
        return this.routers.get(ip) != null;
    }

    public static void reboot() {
        instance = new RouterServices();
    }
}

