/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.fusion;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataInput;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.ITagRender;
import resonant.lib.config.Config;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.tile.TileElectrical;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.atomic.Atomic;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.energy.UnitDisplay;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class TilePlasmaHeater
extends TileElectrical
implements IPacketReceiver,
ITagRender,
IFluidHandler {
    public static final long DIAN = 10000000000L;
    @Config
    public static final int plasmaHeatAmount = 100;
    public final FluidTank tankInputDeuterium = new FluidTank(10000);
    public final FluidTank tankInputTritium = new FluidTank(10000);
    public final FluidTank tankOutput = new FluidTank(10000);
    public float rotation = 0.0f;

    public TilePlasmaHeater() {
        this.energy = new EnergyStorageHandler(10000000000L, 500000000L);
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        if (this.tankInputDeuterium.getFluidAmount() > 0 && this.tankInputTritium.getFluidAmount() > 0) {
            return super.onReceiveEnergy(from, receive, doReceive);
        }
        return 0L;
    }

    public void func_70316_g() {
        super.func_70316_g();
        this.rotation += (float)this.energy.getEnergy() / 10000.0f;
        if (!this.field_70331_k.field_72995_K && this.energy.checkExtract() && this.tankInputDeuterium.getFluidAmount() >= 100 && this.tankInputTritium.getFluidAmount() >= 100) {
            this.tankInputDeuterium.drain(100, true);
            this.tankInputTritium.drain(100, true);
            this.tankOutput.fill(new FluidStack(Atomic.FLUID_PLASMA, 100), true);
            this.energy.extractEnergy();
        }
        if (this.ticks % 80L == 0L) {
            PacketHandler.sendPacketToClients((Packet)this.func_70319_e(), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)25.0);
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{nbt});
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.func_70307_a(PacketHandler.readNBTTagCompound((DataInput)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagCompound deuterium = nbt.func_74775_l("tankInputDeuterium");
        this.tankInputDeuterium.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)deuterium));
        NBTTagCompound tritium = nbt.func_74775_l("tankInputTritium");
        this.tankInputTritium.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tritium));
        NBTTagCompound output = nbt.func_74775_l("tankOutput");
        this.tankOutput.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)output));
    }

    public void func_70310_b(NBTTagCompound nbt) {
        NBTTagCompound compound;
        super.func_70310_b(nbt);
        if (this.tankInputDeuterium.getFluid() != null) {
            compound = new NBTTagCompound();
            this.tankInputDeuterium.getFluid().writeToNBT(compound);
            nbt.func_74782_a("tankInputDeuterium", (NBTBase)compound);
        }
        if (this.tankInputTritium.getFluid() != null) {
            compound = new NBTTagCompound();
            this.tankInputTritium.getFluid().writeToNBT(compound);
            nbt.func_74782_a("tankInputTritium", (NBTBase)compound);
        }
        if (this.tankOutput.getFluid() != null) {
            compound = new NBTTagCompound();
            this.tankOutput.getFluid().writeToNBT(compound);
            nbt.func_74782_a("tankOutput", (NBTBase)compound);
        }
    }

    public float addInformation(HashMap<String, Integer> map, EntityPlayer player) {
        if (this.energy != null) {
            map.put(LanguageUtility.getLocal((String)"tooltip.energy") + ": " + UnitDisplay.getDisplay((double)this.energy.getEnergy(), (UnitDisplay.Unit)UnitDisplay.Unit.JOULES), 0xFFFFFF);
        }
        if (this.tankInputDeuterium.getFluidAmount() > 0) {
            map.put(LanguageUtility.getLocal((String)"fluid.deuterium") + ": " + this.tankInputDeuterium.getFluidAmount() + " L", 0xFFFFFF);
        }
        if (this.tankInputTritium.getFluidAmount() > 0) {
            map.put(LanguageUtility.getLocal((String)"fluid.tritium") + ": " + this.tankInputTritium.getFluidAmount() + " L", 0xFFFFFF);
        }
        if (this.tankOutput.getFluidAmount() > 0) {
            map.put(LanguageUtility.getLocal((String)"fluid.plasma") + ": " + this.tankOutput.getFluidAmount() + " L", 0xFFFFFF);
        }
        return 1.5f;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        return 0L;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.isFluidEqual(Atomic.FLUIDSTACK_DEUTERIUM)) {
            return this.tankInputDeuterium.fill(resource, doFill);
        }
        if (resource.isFluidEqual(Atomic.FLUIDSTACK_TRITIUM)) {
            return this.tankInputTritium.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankOutput.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.getID() == Atomic.FLUID_DEUTERIUM.getID() || fluid.getID() == Atomic.FLUID_TRITIUM.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == Atomic.FLUID_PLASMA;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tankInputDeuterium.getInfo(), this.tankInputTritium.getInfo(), this.tankOutput.getInfo()};
    }
}

