/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.particle.accelerator;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IElectromagnet;
import resonant.lib.prefab.poison.PoisonRadiation;
import resonantinduction.atomic.Atomic;
import resonantinduction.atomic.particle.accelerator.TileAccelerator;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorHelper;

public class EntityParticle
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int MOVE_TICK_RATE = 20;
    public ForgeChunkManager.Ticket updateTicket;
    public boolean didParticleCollide = false;
    private int lastTurn = 60;
    private Vector3 movementVector = new Vector3();
    private ForgeDirection movementDirection = ForgeDirection.NORTH;

    public EntityParticle(World par1World) {
        super(par1World);
        this.func_70105_a(0.3f, 0.3f);
        this.field_70155_l = 4.0;
        this.field_70158_ak = true;
    }

    public EntityParticle(World world, Vector3 pos, Vector3 movementVec, ForgeDirection dir) {
        this(world);
        this.func_70107_b(pos.x, pos.y, pos.z);
        this.movementVector = movementVec;
        this.movementDirection = dir;
    }

    public static boolean canRenderAcceleratedParticle(World world, Vector3 pos) {
        if (pos.getBlockID((IBlockAccess)world) != 0) {
            return false;
        }
        for (int i = 0; i <= 1; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (EntityParticle.isElectromagnet(world, pos, dir)) continue;
            return false;
        }
        return true;
    }

    public static boolean isElectromagnet(World world, Vector3 position, ForgeDirection dir) {
        Vector3 checkPos = position.clone().translate(dir);
        TileEntity tile = checkPos.getTileEntity((IBlockAccess)world);
        if (tile instanceof IElectromagnet) {
            return ((IElectromagnet)tile).isRunning();
        }
        return false;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.movementVector.intX());
        data.writeInt(this.movementVector.intY());
        data.writeInt(this.movementVector.intZ());
        data.writeInt(this.movementDirection.ordinal());
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.movementVector.x = data.readInt();
        this.movementVector.y = data.readInt();
        this.movementVector.z = data.readInt();
        this.movementDirection = ForgeDirection.getOrientation((int)data.readInt());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(20, (Object)3);
        if (this.updateTicket == null) {
            this.updateTicket = ForgeChunkManager.requestTicket((Object)Atomic.INSTANCE, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
            this.updateTicket.getModData();
            this.updateTicket.bindEntity((Entity)this);
        }
    }

    public void func_70071_h_() {
        TileEntity t;
        if (this.field_70173_aa % 10 == 0) {
            this.field_70170_p.func_72956_a((Entity)this, "resonantinduction:accelerator", 1.0f, (float)((double)0.6f + 0.4 * (this.getParticleVelocity() / (double)0.9f)));
        }
        if (!((t = this.field_70170_p.func_72796_p(this.movementVector.intX(), this.movementVector.intY(), this.movementVector.intZ())) instanceof TileAccelerator)) {
            this.func_70106_y();
            return;
        }
        TileAccelerator tileEntity = (TileAccelerator)t;
        if (tileEntity.entityParticle == null) {
            tileEntity.entityParticle = this;
        }
        for (int x = -1; x < 1; ++x) {
            for (int z = -1; z < 1; ++z) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.updateTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(((int)this.field_70165_t >> 4) + x, ((int)this.field_70161_v >> 4) + z));
            }
        }
        try {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(20, (Object)((byte)this.movementDirection.ordinal()));
            } else {
                this.movementDirection = ForgeDirection.getOrientation((int)this.field_70180_af.func_75683_a(20));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double acceleration = 6.0E-4f;
        if (!(EntityParticle.isElectromagnet(this.field_70170_p, new Vector3((Entity)this), this.movementDirection.getRotation(ForgeDirection.UP)) && EntityParticle.isElectromagnet(this.field_70170_p, new Vector3((Entity)this), this.movementDirection.getRotation(ForgeDirection.DOWN)) || this.lastTurn > 0)) {
            acceleration = this.turn();
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.lastTurn = 40;
        }
        --this.lastTurn;
        if (!EntityParticle.canRenderAcceleratedParticle(this.field_70170_p, new Vector3((Entity)this)) || this.field_70132_H) {
            this.explode();
            return;
        }
        Vector3 dongLi = new Vector3();
        dongLi.translate(this.movementDirection);
        dongLi.scale(acceleration);
        this.field_70159_w = Math.min(dongLi.x + this.field_70159_w, (double)0.9f);
        this.field_70181_x = Math.min(dongLi.y + this.field_70181_x, (double)0.9f);
        this.field_70179_y = Math.min(dongLi.z + this.field_70179_y, (double)0.9f);
        this.field_70160_al = true;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70142_S == this.field_70165_t && this.field_70137_T == this.field_70163_u && this.field_70136_U == this.field_70161_v && this.getParticleVelocity() <= 0.0 && this.lastTurn <= 0) {
            this.func_70106_y();
        }
        this.field_70170_p.func_72869_a("portal", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        float radius = 0.5f;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - (double)radius), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + (double)radius), (double)(this.field_70161_v + (double)radius));
        List entitiesNearby = this.field_70170_p.func_72872_a(Entity.class, bounds);
        if (entitiesNearby.size() > 1) {
            this.explode();
            return;
        }
    }

    private double turn() {
        ForgeDirection zuoFangXiang = VectorHelper.getOrientationFromSide((ForgeDirection)this.movementDirection, (ForgeDirection)ForgeDirection.EAST);
        Vector3 zuoBian = new Vector3((Entity)this).floor();
        zuoBian.translate(zuoFangXiang);
        ForgeDirection youFangXiang = VectorHelper.getOrientationFromSide((ForgeDirection)this.movementDirection, (ForgeDirection)ForgeDirection.WEST);
        Vector3 youBian = new Vector3((Entity)this).floor();
        youBian.translate(youFangXiang);
        if (zuoBian.getBlockID((IBlockAccess)this.field_70170_p) == 0) {
            this.movementDirection = zuoFangXiang;
        } else if (youBian.getBlockID((IBlockAccess)this.field_70170_p) == 0) {
            this.movementDirection = youFangXiang;
        } else {
            this.func_70106_y();
            return 0.0;
        }
        this.func_70107_b(Math.floor(this.field_70165_t) + 0.5, Math.floor(this.field_70163_u) + 0.5, Math.floor(this.field_70161_v) + 0.5);
        return this.getParticleVelocity() - this.getParticleVelocity() / Math.min(Math.max(70.0 * this.getParticleVelocity(), 4.0), 30.0);
    }

    public void explode() {
        float radius;
        AxisAlignedBB bounds;
        this.field_70170_p.func_72956_a((Entity)this, "resonantinduction:antimatter", 1.5f, 1.0f - this.field_70170_p.field_73012_v.nextFloat() * 0.3f);
        if (!this.field_70170_p.field_72995_K) {
            List entitiesNearby;
            if (this.getParticleVelocity() > (double)0.45f && (entitiesNearby = this.field_70170_p.func_72872_a(EntityParticle.class, bounds = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)(radius = 1.0f)), (double)(this.field_70163_u - (double)radius), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + (double)radius), (double)(this.field_70161_v + (double)radius)))).size() > 0) {
                this.didParticleCollide = true;
                this.func_70106_y();
                return;
            }
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.getParticleVelocity() * 2.5f, true);
        }
        radius = 6.0f;
        bounds = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - (double)radius), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + (double)radius), (double)(this.field_70161_v + (double)radius));
        List livingNearby = this.field_70170_p.func_72872_a(EntityLiving.class, bounds);
        for (EntityLiving entity : livingNearby) {
            PoisonRadiation.INSTANCE.poisonEntity(new Vector3((Entity)entity), (EntityLivingBase)entity);
        }
        this.func_70106_y();
    }

    public double getParticleVelocity() {
        return Math.abs(this.field_70159_w) + Math.abs(this.field_70181_x) + Math.abs(this.field_70179_y);
    }

    public void func_70108_f(Entity par1Entity) {
        this.explode();
    }

    public void func_70106_y() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.updateTicket);
        super.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.movementVector = new Vector3(nbt.func_74775_l("jiqi"));
        ForgeDirection.getOrientation((int)nbt.func_74771_c("fangXiang"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74782_a("jiqi", (NBTBase)this.movementVector.writeToNBT(new NBTTagCompound()));
        nbt.func_74774_a("fangXiang", (byte)this.movementDirection.ordinal());
    }
}

