/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.process.fission;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.IRotatable;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.Synced;
import resonant.lib.prefab.tile.TileElectricalInventory;
import resonantinduction.atomic.Atomic;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.Settings;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.energy.EnergyStorageHandler;

public class TileNuclearBoiler
extends TileElectricalInventory
implements ISidedInventory,
IPacketReceiver,
IFluidHandler,
IRotatable,
IVoltageInput {
    public static final long DIAN = 50000L;
    public final int SHI_JIAN = 300;
    @Synced
    public final FluidTank waterTank = new FluidTank(Atomic.FLUIDSTACK_WATER.copy(), 5000);
    @Synced
    public final FluidTank gasTank = new FluidTank(Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.copy(), 5000);
    @Synced
    public int timer = 0;
    public float rotation = 0.0f;

    public TileNuclearBoiler() {
        this.energy = new EnergyStorageHandler(100000L);
        this.maxSlots = 4;
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        if (this.nengYong()) {
            return super.onReceiveEnergy(from, receive, doReceive);
        }
        return 0L;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.timer > 0) {
            this.rotation += 0.1f;
        }
        if (!this.field_70331_k.field_72995_K) {
            FluidStack liquid;
            if (this.func_70301_a(1) != null && FluidContainerRegistry.isFilledContainer((ItemStack)this.func_70301_a(1)) && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.func_70301_a(1))).isFluidEqual(Atomic.FLUIDSTACK_WATER) && this.fill(ForgeDirection.UNKNOWN, liquid, false) > 0) {
                ItemStack resultingContainer = this.func_70301_a(1).func_77973_b().getContainerItemStack(this.func_70301_a(1));
                if (resultingContainer == null && this.func_70301_a((int)1).field_77994_a > 1) {
                    --this.func_70301_a((int)1).field_77994_a;
                } else {
                    this.func_70299_a(1, resultingContainer);
                }
                this.waterTank.fill(liquid, true);
            }
            if (this.nengYong()) {
                this.discharge(this.func_70301_a(0));
                if (this.energy.extractEnergy(50000L, false) >= 50000L) {
                    if (this.timer == 0) {
                        this.timer = 300;
                    }
                    if (this.timer > 0) {
                        --this.timer;
                        if (this.timer < 1) {
                            this.yong();
                            this.timer = 0;
                        }
                    } else {
                        this.timer = 0;
                    }
                    this.energy.extractEnergy(50000L, true);
                }
            } else {
                this.timer = 0;
            }
            if (this.ticks % 10L == 0L) {
                this.sendDescPack();
            }
        }
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.timer = data.readInt();
            this.waterTank.setFluid(new FluidStack(Atomic.FLUIDSTACK_WATER.fluidID, data.readInt()));
            this.gasTank.setFluid(new FluidStack(Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.fluidID, data.readInt()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{this.timer, Atomic.getFluidAmount(this.waterTank.getFluid()), Atomic.getFluidAmount(this.gasTank.getFluid())});
    }

    public void sendDescPack() {
        if (!this.field_70331_k.field_72995_K) {
            for (EntityPlayer player : this.getPlayersUsing()) {
                PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)player));
            }
        }
    }

    public boolean nengYong() {
        return this.waterTank.getFluid() != null && this.waterTank.getFluid().amount >= 1000 && this.func_70301_a(3) != null && (Atomic.itemYellowCake.field_77779_bT == this.func_70301_a((int)3).field_77993_c || Atomic.isItemStackUraniumOre(this.func_70301_a(3))) && Atomic.getFluidAmount(this.gasTank.getFluid()) < this.gasTank.getCapacity();
    }

    public void yong() {
        if (this.nengYong()) {
            this.waterTank.drain(1000, true);
            FluidStack liquid = Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.copy();
            liquid.amount = Settings.uraniumHexaflourideRatio * 2;
            this.gasTank.fill(liquid, true);
            this.func_70298_a(3, 1);
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.timer = nbt.func_74762_e("shiJian");
        NBTTagCompound waterCompound = nbt.func_74775_l("water");
        this.waterTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)waterCompound));
        NBTTagCompound gasCompound = nbt.func_74775_l("gas");
        this.gasTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)gasCompound));
    }

    public void func_70310_b(NBTTagCompound nbt) {
        NBTTagCompound compound;
        super.func_70310_b(nbt);
        nbt.func_74768_a("shiJian", this.timer);
        if (this.waterTank.getFluid() != null) {
            compound = new NBTTagCompound();
            this.waterTank.getFluid().writeToNBT(compound);
            nbt.func_74782_a("water", (NBTBase)compound);
        }
        if (this.gasTank.getFluid() != null) {
            compound = new NBTTagCompound();
            this.gasTank.getFluid().writeToNBT(compound);
            nbt.func_74782_a("gas", (NBTBase)compound);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (Atomic.FLUIDSTACK_WATER.isFluidEqual(resource)) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.isFluidEqual(resource)) {
            return this.gasTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.gasTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Atomic.FLUIDSTACK_WATER.fluidID == fluid.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.fluidID == fluid.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.waterTank.getInfo(), this.gasTank.getInfo()};
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 1) {
            return Atomic.isItemStackWaterCell(itemStack);
        }
        if (slotID == 3) {
            return itemStack.field_77993_c == Atomic.itemYellowCake.field_77779_bT;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 1;
            nArray = nArray3;
            nArray3[1] = 3;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack itemStack, int side) {
        return this.func_94041_b(slotID, itemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int j) {
        return slotID == 2;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        return 0L;
    }

    public long getVoltageInput(ForgeDirection from) {
        return 1000L;
    }

    public void onWrongVoltage(ForgeDirection direction, long voltage) {
    }
}

