/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.schematic;

import java.util.HashMap;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.schematic.Schematic;
import resonant.lib.type.Pair;
import resonantinduction.atomic.Atomic;
import universalelectricity.api.vector.Vector3;

public class SchematicFusionReactor
extends Schematic {
    public String getName() {
        return "schematic.fusionReactor.name";
    }

    public HashMap<Vector3, Pair<Integer, Integer>> getStructure(ForgeDirection dir, int size) {
        HashMap<Vector3, Pair<Integer, Integer>> returnMap = new HashMap<Vector3, Pair<Integer, Integer>>();
        int radius = size + 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y <= size; ++y) {
                    Vector3 position = new Vector3((double)x, (double)y, (double)z);
                    double magnitude = Math.sqrt(x * x + z * z);
                    if (!returnMap.containsKey(position)) {
                        returnMap.put(position, (Pair<Integer, Integer>)new Pair((Object)0, (Object)0));
                    }
                    if (!(magnitude <= (double)radius)) continue;
                    if (y == 0 || y == size) {
                        if (!(magnitude >= 1.0)) continue;
                        double yDeviation = (double)(y == 0 ? size / 3 : -size / 3) + (double)(y == 0 ? -1 : 1) * Math.sin(magnitude / (double)radius * Math.PI) * (double)size / 2.0;
                        Vector3 newPos = position.clone().translate(0.0, yDeviation, 0.0);
                        returnMap.put(newPos.round(), (Pair<Integer, Integer>)new Pair((Object)Atomic.blockElectromagnet.field_71990_ca, (Object)1));
                        continue;
                    }
                    if (!(magnitude > (double)(radius - 1))) continue;
                    returnMap.put(position, (Pair<Integer, Integer>)new Pair((Object)Atomic.blockElectromagnet.field_71990_ca, (Object)0));
                }
            }
        }
        for (int y = 0; y < size; ++y) {
            returnMap.put(new Vector3(0.0, (double)y, 0.0), new Pair((Object)Atomic.blockReactorCell.field_71990_ca, (Object)0));
            returnMap.put(new Vector3(1.0, (double)y, 0.0), (Pair<Integer, Integer>)new Pair((Object)Atomic.blockElectromagnet.field_71990_ca, (Object)0));
            returnMap.put(new Vector3(0.0, (double)y, 1.0), (Pair<Integer, Integer>)new Pair((Object)Atomic.blockElectromagnet.field_71990_ca, (Object)0));
            returnMap.put(new Vector3(0.0, (double)y, -1.0), (Pair<Integer, Integer>)new Pair((Object)Atomic.blockElectromagnet.field_71990_ca, (Object)0));
            returnMap.put(new Vector3(-1.0, (double)y, 0.0), (Pair<Integer, Integer>)new Pair((Object)Atomic.blockElectromagnet.field_71990_ca, (Object)0));
        }
        returnMap.put(new Vector3(0.0, 0.0, 0.0), new Pair((Object)Atomic.blockReactorCell.field_71990_ca, (Object)0));
        return returnMap;
    }
}

