/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.core.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectricBlock;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityTerraformBubble;
import micdoodle8.mods.galacticraft.mars.world.gen.GCMarsWorldGenTerraformTree;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class GCMarsTileEntityTerraformer
extends GCCoreTileEntityElectricBlock
implements IInventory,
ISidedInventory,
IDisableableMachine {
    private final int tankCapacity = 2000;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    public boolean active;
    public boolean lastActive;
    public static final float WATTS_PER_TICK = 0.2f;
    private ItemStack[] containingItems = new ItemStack[14];
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public GCMarsEntityTerraformBubble terraformBubble;
    private ArrayList<Vector3> terraformableBlocksList = new ArrayList();
    private ArrayList<Vector3> grassBlockList = new ArrayList();
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public int terraformableBlocksListSize = 0;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public int grassBlocksListSize = 0;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean treesDisabled;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean grassDisabled;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public float size;
    public final double MAX_SIZE = 15.0;
    private int[] useCount = new int[2];

    public GCMarsTileEntityTerraformer() {
        super(0.2f, 50.0f);
    }

    public int getScaledWaterLevel(int i) {
        double fuelLevel = this.waterTank.getFluid() == null ? 0.0 : (double)this.waterTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public void func_70313_j() {
        super.func_70313_j();
    }

    public double getDistanceFromServer(double par1, double par3, double par5) {
        double d3 = (double)this.field_70329_l + 0.5 - par1;
        double d4 = (double)this.field_70330_m + 0.5 - par3;
        double d5 = (double)this.field_70327_n + 0.5 - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public void func_70316_g() {
        int randomIndex;
        super.func_70316_g();
        if (this.terraformBubble == null && !this.field_70331_k.field_72995_K) {
            this.terraformBubble = new GCMarsEntityTerraformBubble(this.field_70331_k, new Vector3((TileEntity)this), this);
            this.terraformBubble.func_70107_b(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72838_d((Entity)this.terraformBubble);
        }
        if (!this.field_70331_k.field_72995_K) {
            FluidStack liquid;
            if (this.containingItems[0] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0])) != null && liquid.getFluid().getName().equals(FluidRegistry.WATER.getName()) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(liquid, true);
                if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[0]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[0])) {
                    this.containingItems[0] = new ItemStack(Item.field_77788_aw, this.containingItems[0].field_77994_a);
                } else {
                    --this.containingItems[0].field_77994_a;
                    if (this.containingItems[0].field_77994_a == 0) {
                        this.containingItems[0] = null;
                    }
                }
            }
            this.active = (double)this.terraformBubble.getSize() == this.MAX_SIZE && this.hasEnoughEnergyToRun && this.getFirstBonemealStack() != null && this.waterTank.getFluid() != null && this.waterTank.getFluid().amount > 0;
        }
        if (!(this.field_70331_k.field_72995_K || this.active == this.lastActive && this.ticks % 20L != 0L)) {
            this.terraformableBlocksList.clear();
            this.grassBlockList.clear();
            if (this.active) {
                int x = (int)Math.floor((float)this.field_70329_l - this.terraformBubble.getSize());
                while ((double)x < Math.ceil((float)this.field_70329_l + this.terraformBubble.getSize())) {
                    int y = (int)Math.floor((float)this.field_70330_m - this.terraformBubble.getSize());
                    while ((double)y < Math.ceil((float)this.field_70330_m + this.terraformBubble.getSize())) {
                        int z = (int)Math.floor((float)this.field_70327_n - this.terraformBubble.getSize());
                        while ((double)z < Math.ceil((float)this.field_70327_n + this.terraformBubble.getSize())) {
                            int blockID = this.field_70331_k.func_72798_a(x, y, z);
                            int blockIDAbove = this.field_70331_k.func_72798_a(x, y + 1, z);
                            if (blockID > 0 && this.getDistanceFromServer(x, y, z) < (double)(this.terraformBubble.getSize() * this.terraformBubble.getSize())) {
                                Block block = Block.field_71973_m[blockID];
                                if (block instanceof ITerraformableBlock && ((ITerraformableBlock)block).isTerraformable(this.field_70331_k, x, y, z)) {
                                    if (!this.grassDisabled && this.getFirstSeedStack() != null) {
                                        this.terraformableBlocksList.add(new Vector3((double)x, (double)y, (double)z));
                                    }
                                } else if (block.field_71990_ca == Block.field_71980_u.field_71990_ca && blockIDAbove == 0 && !this.treesDisabled && this.getFirstSaplingStack() != null) {
                                    this.grassBlockList.add(new Vector3((double)x, (double)y, (double)z));
                                }
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
        }
        if (!this.field_70331_k.field_72995_K && this.terraformableBlocksList.size() > 0 && this.ticks % 15L == 0L) {
            ArrayList<Vector3> terraformableBlocks2 = new ArrayList<Vector3>(this.terraformableBlocksList);
            randomIndex = this.field_70331_k.field_73012_v.nextInt(this.terraformableBlocksList.size());
            Vector3 vec = terraformableBlocks2.get(randomIndex);
            int ID = 0;
            switch (this.field_70331_k.field_73012_v.nextInt(40)) {
                case 0: {
                    if (this.field_70331_k.func_85174_u(vec.intX() - 1, vec.intY(), vec.intZ()) && this.field_70331_k.func_85174_u(vec.intX() + 1, vec.intY(), vec.intZ()) && this.field_70331_k.func_85174_u(vec.intX(), vec.intY(), vec.intZ() - 1) && this.field_70331_k.func_85174_u(vec.intX(), vec.intY(), vec.intZ() + 1)) {
                        ID = Block.field_71942_A.field_71990_ca;
                        break;
                    }
                    ID = Block.field_71980_u.field_71990_ca;
                    break;
                }
                default: {
                    ID = Block.field_71980_u.field_71990_ca;
                }
            }
            this.field_70331_k.func_94575_c(vec.intX(), vec.intY(), vec.intZ(), ID);
            if (ID == Block.field_71980_u.field_71990_ca) {
                this.useCount[0] = this.useCount[0] + 1;
                this.waterTank.drain(1, true);
                this.checkUsage(1);
            } else if (ID == Block.field_71942_A.field_71990_ca) {
                this.checkUsage(2);
            }
            this.terraformableBlocksList.remove(randomIndex);
        }
        if (!this.field_70331_k.field_72995_K && !this.treesDisabled && this.grassBlockList.size() > 0 && this.ticks % 50L == 0L) {
            ArrayList<Vector3> grassBlocks2 = new ArrayList<Vector3>(this.grassBlockList);
            randomIndex = this.field_70331_k.field_73012_v.nextInt(this.grassBlockList.size());
            Vector3 vec = grassBlocks2.get(randomIndex);
            if (new GCMarsWorldGenTerraformTree(true).func_76484_a(this.field_70331_k, this.field_70331_k.field_73012_v, vec.intX(), vec.intY(), vec.intZ())) {
                this.useCount[1] = this.useCount[1] + 1;
                this.waterTank.drain(50, true);
                this.checkUsage(0);
            }
            this.grassBlockList.remove(randomIndex);
        }
        if (!this.field_70331_k.field_72995_K) {
            this.terraformableBlocksListSize = this.terraformableBlocksList.size();
            this.grassBlocksListSize = this.grassBlockList.size();
        }
        this.size = this.hasEnoughEnergyToRun && (!this.grassDisabled || !this.treesDisabled) ? (float)Math.min((double)Math.max(0.0f, this.size + 0.1f), this.MAX_SIZE) : (float)Math.min((double)Math.max(0.0f, this.size - 0.1f), this.MAX_SIZE);
        this.lastActive = this.active;
    }

    private void checkUsage(int type) {
        ItemStack stack = null;
        if ((this.useCount[0] + this.useCount[1]) % 4 == 0 && (stack = this.getFirstBonemealStack()) != null) {
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.containingItems[this.getSelectiveStack((int)2, (int)6)] = null;
            }
        }
        switch (type) {
            case 0: {
                stack = this.getFirstSaplingStack();
                if (stack == null) break;
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) break;
                this.containingItems[this.getSelectiveStack((int)6, (int)10)] = null;
                break;
            }
            case 1: {
                if (this.useCount[0] % 4 != 0 || (stack = this.getFirstSeedStack()) == null) break;
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) break;
                this.containingItems[this.getSelectiveStack((int)10, (int)14)] = null;
                break;
            }
            case 2: {
                this.waterTank.drain(50, true);
            }
        }
    }

    private int getSelectiveStack(int start, int end) {
        for (int i = start; i < end; ++i) {
            ItemStack stack = this.containingItems[i];
            if (stack == null) continue;
            return i;
        }
        return -1;
    }

    public ItemStack getFirstBonemealStack() {
        int index = this.getSelectiveStack(2, 6);
        if (index != -1) {
            return this.containingItems[index];
        }
        return null;
    }

    public ItemStack getFirstSaplingStack() {
        int index = this.getSelectiveStack(6, 10);
        if (index != -1) {
            return this.containingItems[index];
        }
        return null;
    }

    public ItemStack getFirstSeedStack() {
        int index = this.getSelectiveStack(10, 14);
        if (index != -1) {
            return this.containingItems[index];
        }
        return null;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList var2 = nbt.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.size = nbt.func_74760_g("BubbleSize");
        this.useCount = nbt.func_74759_k("UseCountArray");
        if (this.useCount.length == 0) {
            this.useCount = new int[2];
        }
        if (nbt.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        nbt.func_74776_a("BubbleSize", this.size);
        nbt.func_74783_a("UseCountArray", this.useCount);
        if (this.waterTank.getFluid() != null) {
            nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return StatCollector.func_74838_a((String)"container.oxygendistributor.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public int[] func_94128_d(int side) {
        return new int[]{1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this && entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 1 ? itemstack.func_77973_b() instanceof IItemElectric : false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean shouldUseEnergy() {
        return !this.grassDisabled || !this.treesDisabled;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
    }

    public void readExtraNetworkedData(ByteArrayDataInput dataStream) {
    }

    public double getPacketRange() {
        return 320.0;
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_70322_n() + 2));
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(1);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown <= 0) {
            switch (index) {
                case 0: {
                    this.treesDisabled = !this.treesDisabled;
                    break;
                }
                case 1: {
                    this.grassDisabled = !this.grassDisabled;
                }
            }
            this.disableCooldown = 10;
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.treesDisabled;
            }
            case 1: {
                return this.grassDisabled;
            }
        }
        return false;
    }
}

