/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.circuits.analog;

import powercrystals.minefactoryreloaded.circuits.base.StatelessCircuit;

public class Scaler
extends StatelessCircuit {
    private static String[] _inputPinNames = new String[]{"I", "IMn", "IMx", "OMn", "OMx"};

    @Override
    public int getInputCount() {
        return 5;
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    @Override
    public int[] recalculateOutputValues(long l, int[] nArray) {
        if (nArray[4] - nArray[3] == 0 || nArray[2] - nArray[1] == 0) {
            return new int[]{nArray[0]};
        }
        return new int[]{(nArray[0] - nArray[1]) * (nArray[4] - nArray[3]) / (nArray[2] - nArray[1]) + nArray[3]};
    }

    @Override
    public String getUnlocalizedName() {
        return "circuit.mfr.scaler";
    }

    @Override
    public String getInputPinLabel(int n) {
        return _inputPinNames[n];
    }

    @Override
    public String getOutputPinLabel(int n) {
        return "O" + n;
    }
}

