/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.circuits.timing;

import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.circuits.base.StatelessCircuit;

public class Delay
extends StatelessCircuit {
    private int delayTime;
    private ArrayList<Integer> history = new ArrayList();

    @Override
    public int getInputCount() {
        return 2;
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    @Override
    public int[] recalculateOutputValues(long l, int[] nArray) {
        int n = 0;
        this.delayTime = nArray[1];
        if (this.delayTime < 0) {
            this.delayTime = 0;
        }
        this.history.add(0, nArray[0]);
        if (this.history.size() > this.delayTime) {
            n = this.history.get(this.delayTime);
            for (int i = this.delayTime; i < this.history.size(); ++i) {
                this.history.remove(i);
            }
        }
        return new int[]{n};
    }

    @Override
    public String getUnlocalizedName() {
        return "circuit.mfr.delay";
    }

    @Override
    public String getInputPinLabel(int n) {
        return n == 0 ? "I" : "D";
    }

    @Override
    public String getOutputPinLabel(int n) {
        return "O";
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this.delayTime = nBTTagCompound.func_74762_e("delayTime");
        for (int i = 0; i < this.delayTime; ++i) {
            this.history.add(nBTTagCompound.func_74762_e("inputH" + i));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("delayTime", this.delayTime);
        for (Integer n : this.history) {
            int n2 = 0;
            nBTTagCompound.func_74768_a("inputH" + n2, n.intValue());
            ++n2;
        }
    }
}

